/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ThreadMXBeanDumpAllThreadsHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final ThreadMXBeanDumpAllThreadsHandler INSTANCE = new ThreadMXBeanDumpAllThreadsHandler();
    private final ParametersValidator lockedValidator = new ParametersValidator();

    private ThreadMXBeanDumpAllThreadsHandler() {
        this.lockedValidator.registerValidator("locked-monitors", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.lockedValidator.registerValidator("locked-synchronizers", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.lockedValidator.validate(operation);
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        try {
            ThreadInfo[] infos = mbean.dumpAllThreads(operation.require("locked-monitors").asBoolean(), operation.require("locked-synchronizers").asBoolean());
            ModelNode result = context.getResult();
            if (infos != null) {
                result.setEmptyList();
                for (ThreadInfo info : infos) {
                    result.add(PlatformMBeanUtil.getDetypedThreadInfo(info, mbean.isThreadCpuTimeSupported()));
                }
            }
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.completeStep();
    }

    public ModelNode getModelDescription(Locale locale) {
        return PlatformMBeanDescriptions.getDumpThreadsDescripton(locale);
    }
}

