/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.platform.mbean.AbstractPlatformMBeanAttributeHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.dmr.ModelNode;

public class MemoryPoolMXBeanAttributeHandler
extends AbstractPlatformMBeanAttributeHandler {
    public static MemoryPoolMXBeanAttributeHandler INSTANCE = new MemoryPoolMXBeanAttributeHandler();
    private final ParametersValidator usageValidator = new ParametersValidator();

    private MemoryPoolMXBeanAttributeHandler() {
        this.usageValidator.registerValidator("value", (ParameterValidator)new LongRangeValidator(0L));
    }

    @Override
    protected void executeReadAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
        String name = operation.require("name").asString();
        try {
            if (!(PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name) || PlatformMBeanConstants.MEMORY_POOL_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name) || PlatformMBeanConstants.MEMORY_POOL_METRICS.contains(name))) {
                throw MemoryPoolMXBeanAttributeHandler.unknownAttribute(operation);
            }
            MemoryPoolMXBean memoryPoolMXBean = MemoryPoolMXBeanAttributeHandler.getMemoryPoolMXBean(memPoolName);
            MemoryPoolMXBeanAttributeHandler.storeResult(name, context.getResult(), memoryPoolMXBean, memPoolName);
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
    }

    @Override
    protected void executeWriteAttribute(OperationContext context, ModelNode operation) throws OperationFailedException {
        block6: {
            String memPoolName = PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement().getValue();
            MemoryPoolMXBean memoryPoolMXBean = MemoryPoolMXBeanAttributeHandler.getMemoryPoolMXBean(memPoolName);
            String name = operation.require("name").asString();
            try {
                if ("usage-threshold".equals(name)) {
                    this.usageValidator.validate(operation);
                    memoryPoolMXBean.setUsageThreshold(operation.require("value").asLong());
                    break block6;
                }
                if ("collection-usage-threshold".equals(name)) {
                    this.usageValidator.validate(operation);
                    memoryPoolMXBean.setCollectionUsageThreshold(operation.require("value").asLong());
                    break block6;
                }
                if (PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name)) {
                    throw new IllegalStateException(String.format("Write support for attribute %s was not properly implemented", name));
                }
                throw MemoryPoolMXBeanAttributeHandler.unknownAttribute(operation);
            }
            catch (SecurityException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
            catch (UnsupportedOperationException e) {
                throw new OperationFailedException(new ModelNode().set(e.toString()));
            }
        }
    }

    @Override
    protected void register(ManagementResourceRegistration registration) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            registration.registerReadOnlyAttribute("object-name", (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_READ_ATTRIBUTES) {
            registration.registerReadOnlyAttribute(attribute, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES) {
            registration.registerReadWriteAttribute(attribute, (OperationStepHandler)this, (OperationStepHandler)this, AttributeAccess.Storage.RUNTIME);
        }
        for (String attribute : PlatformMBeanConstants.MEMORY_POOL_METRICS) {
            registration.registerMetric(attribute, (OperationStepHandler)this);
        }
    }

    static void storeResult(String name, ModelNode store, MemoryPoolMXBean memoryPoolMXBean, String memPoolName) {
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6 && "object-name".equals(name)) {
            String objName = PlatformMBeanUtil.getObjectNameStringWithNameKey("java.lang:type=MemoryPool", memPoolName);
            store.set(objName);
        } else if ("name".equals(name)) {
            store.set(PlatformMBeanUtil.escapeMBeanName(memoryPoolMXBean.getName()));
        } else if ("type".equals(name)) {
            store.set(memoryPoolMXBean.getType().name());
        } else if ("usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getUsage());
            store.set(usage);
        } else if ("peak-usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getPeakUsage());
            store.set(usage);
        } else if ("valid".equals(name)) {
            store.set(memoryPoolMXBean.isValid());
        } else if ("memory-manager-names".equals(name)) {
            store.setEmptyList();
            for (String mgr : memoryPoolMXBean.getMemoryManagerNames()) {
                store.add(PlatformMBeanUtil.escapeMBeanName(mgr));
            }
        } else if ("usage-threshold".equals(name)) {
            store.set(memoryPoolMXBean.getUsageThreshold());
        } else if ("usage-threshold-exceeded".equals(name)) {
            store.set(memoryPoolMXBean.isUsageThresholdExceeded());
        } else if ("usage-threshold-count".equals(name)) {
            store.set(memoryPoolMXBean.getUsageThresholdCount());
        } else if ("usage-threshold-supported".equals(name)) {
            store.set(memoryPoolMXBean.isUsageThresholdSupported());
        } else if ("collection-usage-threshold".equals(name)) {
            store.set(memoryPoolMXBean.getCollectionUsageThreshold());
        } else if ("collection-usage-threshold-exceeded".equals(name)) {
            store.set(memoryPoolMXBean.isCollectionUsageThresholdExceeded());
        } else if ("collection-usage-threshold-count".equals(name)) {
            store.set(memoryPoolMXBean.getCollectionUsageThresholdCount());
        } else if ("collection-usage-threshold-supported".equals(name)) {
            store.set(memoryPoolMXBean.isCollectionUsageThresholdSupported());
        } else if ("collection-usage".equals(name)) {
            ModelNode usage = PlatformMBeanUtil.getDetypedMemoryUsage(memoryPoolMXBean.getCollectionUsage());
            store.set(usage);
        } else if (PlatformMBeanConstants.MEMORY_POOL_READ_ATTRIBUTES.contains(name) || PlatformMBeanConstants.MEMORY_POOL_READ_WRITE_ATTRIBUTES.contains(name) || PlatformMBeanConstants.MEMORY_POOL_METRICS.contains(name)) {
            throw new IllegalStateException(String.format("Read support for attribute %s was not properly implemented", name));
        }
    }

    static MemoryPoolMXBean getMemoryPoolMXBean(String memPoolName) throws OperationFailedException {
        MemoryPoolMXBean memoryPoolMXBean = null;
        for (MemoryPoolMXBean mbean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!memPoolName.equals(PlatformMBeanUtil.escapeMBeanName(mbean.getName()))) continue;
            memoryPoolMXBean = mbean;
        }
        if (memoryPoolMXBean == null) {
            throw new OperationFailedException(new ModelNode().set(String.format("No MemoryPoolMXBean with name %s currently exists", memPoolName)));
        }
        return memoryPoolMXBean;
    }
}

