/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.EnumSet;
import java.util.Locale;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonProviders;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.platform.mbean.BufferPoolMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.ClassLoadingMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.CompilationMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.CompilationMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.GarbageCollectorMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryMXBeanGCHandler;
import org.jboss.as.platform.mbean.MemoryManagerMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.MemoryPoolMXBeanResetPeakUsageHandler;
import org.jboss.as.platform.mbean.OperatingSystemMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.OperatingSystemMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.as.platform.mbean.PlatformMBeanUtil;
import org.jboss.as.platform.mbean.RuntimeMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.RuntimeMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanAttributeHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanCpuTimeHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanDumpAllThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanFindDeadlockedThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanFindMonitorDeadlockedThreadsHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanReadResourceHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanResetPeakThreadCountHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanThreadInfoHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanThreadInfosHandler;
import org.jboss.as.platform.mbean.ThreadMXBeanUserTimeHandler;
import org.jboss.dmr.ModelNode;

public class PlatformMBeanResourceRegistrar {
    private static EnumSet RUNTIME_ONLY_FLAG = EnumSet.of(OperationEntry.Flag.RUNTIME_ONLY);

    public static void registerPlatformMBeanResources(ManagementResourceRegistration parent) {
        ManagementResourceRegistration root = parent.registerSubModel(PathElement.pathElement((String)"core-service", (String)"platform-mbean"), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getRootResource(locale);
            }
        });
        ManagementResourceRegistration classloading = root.registerSubModel(PlatformMBeanConstants.CLASS_LOADING_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getClassLoadingResource(locale);
            }
        });
        ClassLoadingMXBeanAttributeHandler.INSTANCE.register(classloading);
        if (ManagementFactory.getCompilationMXBean() != null) {
            ManagementResourceRegistration compilation = root.registerSubModel(PlatformMBeanConstants.COMPILATION_PATH, new DescriptionProvider(){

                public ModelNode getModelDescription(Locale locale) {
                    return PlatformMBeanDescriptions.getCompilationResource(locale);
                }
            });
            compilation.registerOperationHandler("read-resource", (OperationStepHandler)CompilationMXBeanReadResourceHandler.INSTANCE, CommonProviders.READ_RESOURCE_PROVIDER, RUNTIME_ONLY_FLAG);
            CompilationMXBeanAttributeHandler.INSTANCE.register(compilation);
        }
        ManagementResourceRegistration gcRoot = root.registerSubModel(PlatformMBeanConstants.GARBAGE_COLLECTOR_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getGarbageCollectorRootResource(locale);
            }
        });
        ManagementResourceRegistration gc = gcRoot.registerSubModel(PathElement.pathElement((String)"name"), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getGarbageCollectorResource(locale);
            }
        });
        GarbageCollectorMXBeanAttributeHandler.INSTANCE.register(gc);
        ManagementResourceRegistration memMgrRoot = root.registerSubModel(PlatformMBeanConstants.MEMORY_MANAGER_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getMemoryManagerRootResource(locale);
            }
        });
        ManagementResourceRegistration memMgr = memMgrRoot.registerSubModel(PathElement.pathElement((String)"name"), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getMemoryManagerResource(locale);
            }
        });
        MemoryManagerMXBeanAttributeHandler.INSTANCE.register(memMgr);
        ManagementResourceRegistration memory = root.registerSubModel(PlatformMBeanConstants.MEMORY_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getMemoryResource(locale);
            }
        });
        MemoryMXBeanAttributeHandler.INSTANCE.register(memory);
        memory.registerOperationHandler("gc", (OperationStepHandler)MemoryMXBeanGCHandler.INSTANCE, (DescriptionProvider)MemoryMXBeanGCHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        ManagementResourceRegistration memPoolRoot = root.registerSubModel(PlatformMBeanConstants.MEMORY_POOL_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getMemoryPoolRootResource(locale);
            }
        });
        ManagementResourceRegistration memPool = memPoolRoot.registerSubModel(PathElement.pathElement((String)"name"), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getMemoryPoolResource(locale);
            }
        });
        memPool.registerOperationHandler("read-resource", (OperationStepHandler)MemoryPoolMXBeanReadResourceHandler.INSTANCE, CommonProviders.READ_RESOURCE_PROVIDER, RUNTIME_ONLY_FLAG);
        memPool.registerOperationHandler("reset-peak-usage", (OperationStepHandler)MemoryPoolMXBeanResetPeakUsageHandler.INSTANCE, (DescriptionProvider)MemoryPoolMXBeanResetPeakUsageHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        MemoryPoolMXBeanAttributeHandler.INSTANCE.register(memPool);
        ManagementResourceRegistration opSys = root.registerSubModel(PlatformMBeanConstants.OPERATING_SYSTEM_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getOperatingSystemResource(locale);
            }
        });
        opSys.registerOperationHandler("read-resource", (OperationStepHandler)OperatingSystemMXBeanReadResourceHandler.INSTANCE, CommonProviders.READ_RESOURCE_PROVIDER, RUNTIME_ONLY_FLAG);
        OperatingSystemMXBeanAttributeHandler.INSTANCE.register(opSys);
        ManagementResourceRegistration runtime = root.registerSubModel(PlatformMBeanConstants.RUNTIME_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getRuntimeResource(locale);
            }
        });
        runtime.registerOperationHandler("read-resource", (OperationStepHandler)RuntimeMXBeanReadResourceHandler.INSTANCE, CommonProviders.READ_RESOURCE_PROVIDER, RUNTIME_ONLY_FLAG);
        RuntimeMXBeanAttributeHandler.INSTANCE.register(runtime);
        ManagementResourceRegistration threads = root.registerSubModel(PlatformMBeanConstants.THREADING_PATH, new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                return PlatformMBeanDescriptions.getThreadingResource(locale);
            }
        });
        threads.registerOperationHandler("read-resource", (OperationStepHandler)ThreadMXBeanReadResourceHandler.INSTANCE, CommonProviders.READ_RESOURCE_PROVIDER, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("reset-peak-thread-count", (OperationStepHandler)ThreadMXBeanResetPeakThreadCountHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanResetPeakThreadCountHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("find-deadlocked-threads", (OperationStepHandler)ThreadMXBeanFindDeadlockedThreadsHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanFindDeadlockedThreadsHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("find-monitor-deadlocked-threads", (OperationStepHandler)ThreadMXBeanFindMonitorDeadlockedThreadsHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanFindMonitorDeadlockedThreadsHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("get-thread-info", (OperationStepHandler)ThreadMXBeanThreadInfoHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanThreadInfoHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("get-thread-infos", (OperationStepHandler)ThreadMXBeanThreadInfosHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanThreadInfosHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("get-thread-cpu-time", (OperationStepHandler)ThreadMXBeanCpuTimeHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanCpuTimeHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("get-thread-user-time", (OperationStepHandler)ThreadMXBeanUserTimeHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanUserTimeHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        threads.registerOperationHandler("dump-all-threads", (OperationStepHandler)ThreadMXBeanDumpAllThreadsHandler.INSTANCE, (DescriptionProvider)ThreadMXBeanDumpAllThreadsHandler.INSTANCE, RUNTIME_ONLY_FLAG);
        ThreadMXBeanAttributeHandler.INSTANCE.register(threads);
        if (PlatformMBeanUtil.JVM_MAJOR_VERSION > 6) {
            ManagementResourceRegistration bufPoolRoot = root.registerSubModel(PlatformMBeanConstants.BUFFER_POOL_PATH, new DescriptionProvider(){

                public ModelNode getModelDescription(Locale locale) {
                    return PlatformMBeanDescriptions.getBufferPoolRootResource(locale);
                }
            });
            ManagementResourceRegistration bufPool = bufPoolRoot.registerSubModel(PathElement.pathElement((String)"name"), new DescriptionProvider(){

                public ModelNode getModelDescription(Locale locale) {
                    return PlatformMBeanDescriptions.getBufferPoolResource(locale);
                }
            });
            BufferPoolMXBeanAttributeHandler.INSTANCE.register(bufPool);
        }
    }

    private PlatformMBeanResourceRegistrar() {
    }
}

