/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.LongRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.dmr.ModelNode;

public class ThreadMXBeanCpuTimeHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final ThreadMXBeanCpuTimeHandler INSTANCE = new ThreadMXBeanCpuTimeHandler();
    private final ParametersValidator validator = new ParametersValidator();

    private ThreadMXBeanCpuTimeHandler() {
        this.validator.registerValidator("id", (ParameterValidator)new LongRangeValidator(1L));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.validator.validate(operation);
        try {
            long id = operation.require("id").asLong();
            context.getResult().set(ManagementFactory.getThreadMXBean().getThreadCpuTime(id));
        }
        catch (UnsupportedOperationException e) {
            throw new OperationFailedException(new ModelNode().set(e.toString()));
        }
        context.stepCompleted();
    }

    public ModelNode getModelDescription(Locale locale) {
        return PlatformMBeanDescriptions.getThreadCpuTimeOperation(locale);
    }
}

