/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.pojo.ParseResult;
import org.jboss.as.pojo.descriptor.KernelDeploymentXmlDescriptor;
import org.jboss.as.pojo.descriptor.KernelDeploymentXmlDescriptorParser;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.util.SuffixMatchFilter;

public class KernelDeploymentParsingProcessor
implements DeploymentUnitProcessor {
    private final XMLMapper xmlMapper = XMLMapper.Factory.create();
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public KernelDeploymentParsingProcessor() {
        this.xmlMapper.registerRootElement(new QName("urn:jboss:pojo:7.0", "deployment"), (XMLElementReader)new KernelDeploymentXmlDescriptorParser());
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        VirtualFile deploymentRoot = ((ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT)).getRoot();
        this.parseDescriptors(unit, deploymentRoot);
        List resourceRoots = unit.getAttachmentList(Attachments.RESOURCE_ROOTS);
        for (ResourceRoot root : resourceRoots) {
            this.parseDescriptors(unit, root.getRoot());
        }
    }

    protected void parseDescriptors(DeploymentUnit unit, VirtualFile root) throws DeploymentUnitProcessingException {
        if (root == null || !root.exists()) {
            return;
        }
        Collection<Object> beans = Collections.emptySet();
        String name = root.getName();
        if (name.endsWith("jboss-beans.xml")) {
            beans = Collections.singleton(root);
        } else {
            VirtualFile metainf = root.getChild("META-INF");
            if (metainf.exists()) {
                try {
                    beans = metainf.getChildren((VirtualFileFilter)new SuffixMatchFilter("jboss-beans.xml"));
                }
                catch (IOException e) {
                    throw new DeploymentUnitProcessingException((Throwable)e);
                }
            }
        }
        for (VirtualFile beansXmlFile : beans) {
            this.parseDescriptor(unit, beansXmlFile);
        }
    }

    protected void parseDescriptor(DeploymentUnit unit, VirtualFile beansXmlFile) throws DeploymentUnitProcessingException {
        block7: {
            if (beansXmlFile == null || !beansXmlFile.exists()) {
                return;
            }
            InputStream xmlStream = null;
            try {
                xmlStream = beansXmlFile.openStream();
                XMLStreamReader reader = this.inputFactory.createXMLStreamReader(xmlStream);
                ParseResult result = new ParseResult();
                this.xmlMapper.parseDocument(result, reader);
                KernelDeploymentXmlDescriptor xmlDescriptor = (KernelDeploymentXmlDescriptor)result.getResult();
                if (xmlDescriptor != null) {
                    unit.addToAttachmentList(KernelDeploymentXmlDescriptor.ATTACHMENT_KEY, (Object)xmlDescriptor);
                    break block7;
                }
                throw new DeploymentUnitProcessingException("Failed to parse POJO xml [" + beansXmlFile + "]");
            }
            catch (Exception e) {
                throw new DeploymentUnitProcessingException("Failed to parse POJO xml [" + beansXmlFile + "]", (Throwable)e);
            }
            finally {
                VFSUtils.safeClose((Closeable)xmlStream);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

