/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.ConstructorConfig;
import org.jboss.as.pojo.descriptor.FactoryConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.AbstractPojoPhase;
import org.jboss.as.pojo.service.Configurator;
import org.jboss.as.pojo.service.ConfiguredPojoPhase;
import org.jboss.as.pojo.service.ConstructorJoinpoint;
import org.jboss.as.pojo.service.DefaultBeanInfo;
import org.jboss.as.pojo.service.DescribedPojoPhase;
import org.jboss.as.pojo.service.Joinpoint;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.as.pojo.service.ReflectionJoinpoint;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public class InstantiatedPojoPhase
extends AbstractPojoPhase {
    private final DescribedPojoPhase describedPojoPhase;

    public InstantiatedPojoPhase(DescribedPojoPhase describedPojoPhase) {
        this.describedPojoPhase = describedPojoPhase;
    }

    @Override
    protected BeanState getLifecycleState() {
        return BeanState.INSTANTIATED;
    }

    @Override
    protected AbstractPojoPhase createNextPhase() {
        return new ConfiguredPojoPhase();
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            DefaultBeanInfo beanInfo = this.getBeanInfo();
            Joinpoint instantiateJoinpoint = null;
            ValueConfig[] parameters = new ValueConfig[]{};
            String[] types = Configurator.NO_PARAMS_TYPES;
            ConstructorConfig ctorConfig = this.getBeanConfig().getConstructor();
            if (ctorConfig != null) {
                parameters = ctorConfig.getParameters();
                types = Configurator.getTypes(parameters);
                String factoryClass = ctorConfig.getFactoryClass();
                FactoryConfig factory = ctorConfig.getFactory();
                if (factoryClass != null || factory != null) {
                    String factoryMethod = ctorConfig.getFactoryMethod();
                    if (factoryMethod == null) {
                        throw new StartException("Missing factory method in ctor configuration: " + this.getBeanConfig());
                    }
                    if (factoryClass != null) {
                        Class<?> factoryClazz = Class.forName(factoryClass, false, (ClassLoader)this.getModule().getClassLoader());
                        Method method = Configurator.findMethod(this.getIndex(), factoryClazz, factoryMethod, types, true, true, true);
                        MethodJoinpoint mj = new MethodJoinpoint(method);
                        mj.setTarget((Value<Object>)new ImmediateValue(null));
                        mj.setParameters(parameters);
                        instantiateJoinpoint = mj;
                    } else if (factory != null) {
                        ReflectionJoinpoint rj = new ReflectionJoinpoint(factory.getBeanInfo(), factoryMethod, types);
                        rj.setTarget((Value<Object>)new ImmediateValue(factory.getValue(null)));
                        rj.setParameters(parameters);
                        instantiateJoinpoint = rj;
                    }
                }
            }
            if (instantiateJoinpoint == null) {
                if (beanInfo == null) {
                    throw new StartException("Missing bean info, set bean's class attribute: " + this.getBeanConfig());
                }
                Constructor ctor = types.length == 0 ? beanInfo.getConstructor(new String[0]) : beanInfo.findConstructor(types);
                ConstructorJoinpoint constructorJoinpoint = new ConstructorJoinpoint(ctor);
                constructorJoinpoint.setParameters(parameters);
                instantiateJoinpoint = constructorJoinpoint;
            }
            this.setBean(instantiateJoinpoint.dispatch());
            if (beanInfo == null) {
                beanInfo = new DefaultBeanInfo(this.getIndex(), this.getBean().getClass());
                this.setBeanInfo(beanInfo);
                this.describedPojoPhase.setBeanInfo(beanInfo);
            }
        }
        catch (StartException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new StartException(t);
        }
        super.start(context);
    }
}

