/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Method;
import org.jboss.as.pojo.descriptor.LifecycleConfig;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.service.AbstractPojoPhase;
import org.jboss.as.pojo.service.Configurator;
import org.jboss.as.pojo.service.Joinpoint;
import org.jboss.as.pojo.service.MethodJoinpoint;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

public abstract class LifecyclePojoPhase
extends AbstractPojoPhase {
    protected abstract LifecycleConfig getUpConfig();

    protected abstract LifecycleConfig getDownConfig();

    protected abstract String defaultUp();

    protected abstract String defaultDown();

    protected Joinpoint createJoinpoint(LifecycleConfig config, String defaultMethod) {
        Method method;
        ValueConfig[] params = null;
        if (config == null) {
            try {
                method = this.getBeanInfo().getMethod(defaultMethod, new String[0]);
            }
            catch (Exception t) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Ignoring default " + this.defaultUp() + " invocation."), (Throwable)t);
                }
                return null;
            }
        } else {
            String methodName = config.getMethodName();
            if (methodName == null) {
                methodName = defaultMethod;
            }
            ValueConfig[] parameters = config.getParameters();
            String[] types = Configurator.getTypes(parameters);
            method = this.getBeanInfo().findMethod(methodName, types);
            params = parameters;
        }
        MethodJoinpoint joinpoint = new MethodJoinpoint(method);
        joinpoint.setTarget((Value<Object>)new ImmediateValue(this.getBean()));
        joinpoint.setParameters(params);
        return joinpoint;
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            Joinpoint joinpoint = this.createJoinpoint(this.getUpConfig(), this.defaultUp());
            if (joinpoint != null) {
                joinpoint.dispatch();
            }
        }
        catch (Throwable t) {
            throw new StartException(t);
        }
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        try {
            Joinpoint joinpoint = this.createJoinpoint(this.getDownConfig(), this.defaultDown());
            if (joinpoint != null) {
                joinpoint.dispatch();
            }
        }
        catch (Throwable t) {
            this.log.debug((Object)("Exception at " + this.defaultDown() + " phase."), t);
        }
    }
}

