/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jboss.as.pojo.PojoMessages;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.as.pojo.service.Configurator;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;

public class DefaultBeanInfo<T>
implements BeanInfo<T> {
    private final List<ClassReflectionIndex> indexes = new ArrayList<ClassReflectionIndex>();
    private final Class beanClass;
    private DeploymentReflectionIndex index;
    private Class currentClass;

    public DefaultBeanInfo(DeploymentReflectionIndex index, Class<T> beanClass) {
        this.index = index;
        this.beanClass = beanClass;
        this.currentClass = beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <U> U lookup(Lookup<U> lookup, int start, int depth) {
        int size;
        List<ClassReflectionIndex> list = this.indexes;
        synchronized (list) {
            size = this.indexes.size();
            for (int i = start; i < depth && i < size; ++i) {
                U result = lookup.lookup(this.indexes.get(i));
                if (result == null) continue;
                return result;
            }
        }
        if (this.currentClass == null) {
            return null;
        }
        list = this.indexes;
        synchronized (list) {
            ClassReflectionIndex cri = this.index.getClassIndex(this.currentClass);
            this.indexes.add(cri);
            this.currentClass = this.currentClass.getSuperclass();
        }
        return this.lookup(lookup, size, depth);
    }

    @Override
    public Constructor<T> getConstructor(final String ... parameterTypes) {
        return (Constructor)this.lookup(new Lookup<Constructor<T>>(){

            @Override
            public Constructor<T> lookup(ClassReflectionIndex index) {
                return index.getConstructor(parameterTypes);
            }
        }, 0, 1);
    }

    @Override
    public Constructor<T> findConstructor(final String ... parameterTypes) {
        return (Constructor)this.lookup(new Lookup<Constructor<T>>(){

            @Override
            public Constructor<T> lookup(ClassReflectionIndex index) {
                Collection ctors = index.getConstructors();
                for (Constructor c : ctors) {
                    if (!Configurator.equals(parameterTypes, c.getParameterTypes())) continue;
                    return c;
                }
                throw PojoMessages.MESSAGES.ctorNotFound(Arrays.toString(parameterTypes), DefaultBeanInfo.this.beanClass.getName());
            }
        }, 0, 1);
    }

    @Override
    public Field getField(final String name) {
        return this.lookup(new Lookup<Field>(){

            @Override
            public Field lookup(ClassReflectionIndex index) {
                return index.getField(name);
            }
        }, 0, Integer.MAX_VALUE);
    }

    @Override
    public Method getMethod(final String name, final String ... parameterTypes) {
        return this.lookup(new Lookup<Method>(){

            @Override
            public Method lookup(ClassReflectionIndex index) {
                Collection methods = index.getMethods(name, parameterTypes);
                if (methods.size() != 1) {
                    throw PojoMessages.MESSAGES.ambigousMatch(methods);
                }
                return (Method)methods.iterator().next();
            }
        }, 0, Integer.MAX_VALUE);
    }

    @Override
    public Method findMethod(String name, String ... parameterTypes) {
        return Configurator.findMethod(this.index, this.beanClass, name, parameterTypes, false, true, true);
    }

    @Override
    public Method getGetter(String propertyName, final Class<?> type) {
        boolean isBoolean = Boolean.TYPE.equals(type);
        final String name = (isBoolean ? "is" : "get") + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method result = this.lookup(new Lookup<Method>(){

            @Override
            public Method lookup(ClassReflectionIndex index) {
                Collection methods = index.getAllMethods(name, 0);
                if (type == null) {
                    if (methods.size() == 1) {
                        return (Method)methods.iterator().next();
                    }
                    return null;
                }
                for (Method m : methods) {
                    Class<?> pt = m.getReturnType();
                    if (!pt.isAssignableFrom(type)) continue;
                    return m;
                }
                return null;
            }
        }, 0, Integer.MAX_VALUE);
        if (result == null) {
            throw PojoMessages.MESSAGES.getterNotFound(type, this.beanClass.getName());
        }
        return result;
    }

    @Override
    public Method getSetter(String propertyName, final Class<?> type) {
        final String name = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        Method result = this.lookup(new Lookup<Method>(){

            @Override
            public Method lookup(ClassReflectionIndex index) {
                Collection methods = index.getAllMethods(name, 1);
                if (type == null) {
                    if (methods.size() == 1) {
                        return (Method)methods.iterator().next();
                    }
                    return null;
                }
                for (Method m : methods) {
                    Class<?> pt = m.getParameterTypes()[0];
                    if (!pt.isAssignableFrom(type)) continue;
                    return m;
                }
                return null;
            }
        }, 0, Integer.MAX_VALUE);
        if (result == null) {
            throw PojoMessages.MESSAGES.setterNotFound(type, this.beanClass.getName());
        }
        return result;
    }

    private static interface Lookup<U> {
        public U lookup(ClassReflectionIndex var1);
    }
}

