/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.jboss.as.process.ManagedProcess;
import org.jboss.as.process.ProcessManagerServerHandler;
import org.jboss.as.protocol.Connection;
import org.jboss.as.protocol.ConnectionHandler;
import org.jboss.as.protocol.ProtocolServer;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.logging.Logger;

public final class ProcessManager {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.process-manager");
    private final Object lock = new Object();
    private final Map<String, ManagedProcess> processes = new HashMap<String, ManagedProcess>();
    private final Map<Key, ManagedProcess> processesByKey = new HashMap<Key, ManagedProcess>();
    private final ProtocolServer server;
    private final Random rng;
    private final Set<Connection> managerConnections = new HashSet<Connection>();
    private boolean shutdown;
    private final PrintStream stdout;
    private final PrintStream stderr;

    public ProcessManager(ProtocolServer.Configuration configuration, PrintStream stdout, PrintStream stderr) throws IOException {
        this.stdout = stdout;
        this.stderr = stderr;
        this.rng = new Random(new SecureRandom().nextLong());
        configuration.setConnectionHandler((ConnectionHandler)new ProcessManagerServerHandler(this));
        ProtocolServer server = new ProtocolServer(configuration);
        server.start();
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagerConnection(Connection connection) {
        Object object = this.lock;
        synchronized (object) {
            this.managerConnections.add(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeManagerConnection(Connection connection) {
        Object object = this.lock;
        synchronized (object) {
            this.managerConnections.remove(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcess(String processName, List<String> command, Map<String, String> env, String workingDirectory, boolean isInitial) {
        Object object = this.lock;
        synchronized (object) {
            for (String s : command) {
                if (s != null) continue;
                throw new IllegalArgumentException("command contains a null component");
            }
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            if (processes.containsKey(processName)) {
                log.warnf("Attempted to register duplicate-named process '%s'", (Object)processName);
                return;
            }
            byte[] authKey = new byte[16];
            this.rng.nextBytes(authKey);
            ManagedProcess process = new ManagedProcess(processName, command, env, workingDirectory, this.lock, this, authKey, isInitial);
            processes.put(processName, process);
            this.processesByKey.put(new Key(authKey), process);
            for (Connection connection : this.managerConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(16);
                        StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)os);
                    }
                }
                catch (IOException e) {
                    log.errorf("Failed to write PROCESS_ADDED message to manager connection: %s", (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                log.warnf("Attempted to start non-existent process '%s'", (Object)processName);
                return;
            }
            process.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                log.warnf("Attempted to stop non-existent process '%s'", (Object)processName);
                return;
            }
            process.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcess(String processName) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(processName);
            if (process == null) {
                log.warnf("Attempted to remove non-existent process '%s'", (Object)processName);
                return;
            }
            processes.remove(processName);
            this.processesByKey.remove(new Key(process.getAuthKey()));
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStdin(String recipient, InputStream source) {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            Map<String, ManagedProcess> processes = this.processes;
            ManagedProcess process = processes.get(recipient);
            if (process == null) {
                return;
            }
            process.sendStdin(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            log.info((Object)"Shutting down process manager");
            this.shutdown = true;
            for (ManagedProcess process : this.processes.values()) {
                process.shutdown();
            }
            while (!this.processes.isEmpty()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            log.info((Object)"All processes finished; exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedProcess getServerByAuthCode(byte[] code) {
        Object object = this.lock;
        synchronized (object) {
            return this.processesByKey.get(new Key(code));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStarted(String processName) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managerConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(17);
                        StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)os);
                    }
                }
                catch (IOException e) {
                    log.errorf("Failed to write PROCESS_STARTED message to manager connection: %s", (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStopped(String processName, long uptime) {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managerConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(18);
                        StreamUtils.writeUTFZBytes((OutputStream)os, (String)processName);
                        StreamUtils.writeLong((OutputStream)os, (long)uptime);
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)os);
                    }
                }
                catch (IOException e) {
                    log.errorf("Failed to write PROCESS_STOPPED message to manager connection: %s", (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendInventory() {
        Object object = this.lock;
        synchronized (object) {
            for (Connection connection : this.managerConnections) {
                try {
                    OutputStream os = connection.writeMessage();
                    try {
                        os.write(20);
                        Collection<ManagedProcess> processCollection = this.processes.values();
                        StreamUtils.writeInt((OutputStream)os, (int)processCollection.size());
                        for (ManagedProcess process : processCollection) {
                            StreamUtils.writeUTFZBytes((OutputStream)os, (String)process.getProcessName());
                            os.write(process.getAuthKey());
                            StreamUtils.writeBoolean((OutputStream)os, (boolean)process.isRunning());
                        }
                        os.close();
                    }
                    finally {
                        StreamUtils.safeClose((Closeable)os);
                    }
                }
                catch (IOException e) {
                    log.errorf("Failed to write PROCESS_INVENTORY message to manager connection: %s", (Object)e);
                }
            }
        }
    }

    public ProtocolServer getServer() {
        return this.server;
    }

    PrintStream getStdout() {
        return this.stdout;
    }

    PrintStream getStderr() {
        return this.stderr;
    }

    private static final class Key {
        private final byte[] authKey;
        private final int hashCode;

        public Key(byte[] authKey) {
            this.authKey = authKey;
            this.hashCode = Arrays.hashCode(authKey);
        }

        public boolean equals(Object other) {
            return other instanceof Key && this.equals((Key)other);
        }

        public boolean equals(Key other) {
            return this == other || other != null && Arrays.equals(this.authKey, other.authKey);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

