/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.protocol.ProtocolChannel;
import org.jboss.as.protocol.ProtocolLogger;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.FlushableDataOutputImpl;
import org.jboss.as.protocol.mgmt.ManagementByeByeHeader;
import org.jboss.as.protocol.mgmt.ManagementChannelPinger;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementPingHeader;
import org.jboss.as.protocol.mgmt.ManagementPongHeader;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHandler;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.SimpleDataInput;
import org.jboss.marshalling.SimpleDataOutput;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.HandleableCloseable;
import org.jboss.remoting3.MessageInputStream;
import org.xnio.IoUtils;

public class ManagementChannel
extends ProtocolChannel {
    private final ManagementChannelPinger pinger = ManagementChannelPinger.getInstance();
    private final RequestReceiver requestReceiver = new RequestReceiver();
    private final ResponseReceiver responseReceiver = new ResponseReceiver();
    private final AtomicBoolean byeByeSent = new AtomicBoolean();
    private volatile long lastResponseReceived;
    private AtomicBoolean awaitingPong = new AtomicBoolean();

    ManagementChannel(String name, Channel channel) {
        super(name, channel);
        this.pinger.addChannel(this);
    }

    @Override
    public void close() throws IOException {
        this.sendByeBye();
        super.close();
    }

    @Override
    public void writeShutdown() throws IOException {
        this.sendByeBye();
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendByeBye() throws IOException {
        if (!this.byeByeSent.compareAndSet(false, true)) {
            return;
        }
        ProtocolLogger.ROOT_LOGGER.tracef("Closing %s by sending bye bye", this);
        this.pinger.removeChannel(this);
        ManagementByeByeHeader byeByeHeader = new ManagementByeByeHeader(1);
        try {
            SimpleDataOutput out = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)this.writeMessage()));
            try {
                byeByeHeader.write((DataOutput)out);
                return;
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                IoUtils.safeClose((Closeable)out);
            }
        }
        finally {
            ProtocolLogger.ROOT_LOGGER.tracef("Invoking close on %s", this);
            super.close();
        }
    }

    public void setOperationHandler(ManagementOperationHandler handler) {
        this.requestReceiver.setOperationHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void doHandle(MessageInputStream message) {
        ProtocolLogger.ROOT_LOGGER.tracef("%s handling incoming data", this);
        input = new SimpleDataInput(Marshalling.createByteInput((InputStream)message));
        error = null;
        requestHeader = null;
        requestHandler = null;
        wasPing = false;
        try {
            header = ManagementProtocolHeader.parse((DataInput)input);
            switch (header.getType()) {
                case 2: {
                    requestHeader = (ManagementRequestHeader)header;
                    requestHandler = RequestReceiver.access$300(this.requestReceiver, requestHeader, (DataInput)input);
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.gotIncomingResponse();
                    ResponseReceiver.access$400(this.responseReceiver, (ManagementResponseHeader)header, (DataInput)input);
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 4: {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received bye bye on %s, closing", this);
                    this.close();
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 5: {
                    wasPing = true;
                    ProtocolLogger.ROOT_LOGGER.tracef("Received ping on %s", this);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 6: {
                    ProtocolLogger.ROOT_LOGGER.tracef("Received pong on %s", this);
                    this.gotIncomingResponse();
                    break;
                }
                ** default:
lbl35:
                // 1 sources

                break;
            }
        }
        catch (Exception e) {
            error = e;
            ProtocolLogger.ROOT_LOGGER.tracef(e, "%s error handling incoming data", this);
        }
        finally {
            ProtocolLogger.ROOT_LOGGER.tracef("%s done handling incoming data", this);
            try {
                while (input.read() != -1) {
                }
            }
            catch (IOException ignore) {}
            IoUtils.safeClose((Closeable)input);
            IoUtils.safeClose((Closeable)message);
        }
        if (requestHeader != null) {
            if (error == null) {
                try {
                    RequestReceiver.access$500(this.requestReceiver, requestHeader, requestHandler);
                }
                catch (Exception e) {
                    error = e;
                }
            }
            if (error != null) {
                ProtocolLogger.ROOT_LOGGER.tracef(error, "Error processing request %s", this);
            }
            RequestReceiver.access$600(this.requestReceiver, requestHeader, requestHandler, error);
        } else if (wasPing) {
            ProtocolLogger.ROOT_LOGGER.tracef("Sending pong on %s", this);
            pongHeader = new ManagementPongHeader(1);
            this.sendHeaderAndCloseOnError(pongHeader);
        }
    }

    private void gotIncomingResponse() {
        ProtocolLogger.ROOT_LOGGER.tracef("Resetting ping/response status on %s", this);
        this.lastResponseReceived = System.currentTimeMillis();
        this.awaitingPong.set(false);
    }

    void executeRequest(ManagementRequest<?> request, ManagementResponseHandler<?> responseHandler) throws IOException {
        this.addCloseHandler(request, responseHandler);
        this.responseReceiver.registerResponseHandler(request.getCurrentRequestId(), responseHandler);
        FlushableDataOutputImpl output = FlushableDataOutputImpl.create(this.writeMessage());
        try {
            ManagementRequestHeader managementRequestHeader = new ManagementRequestHeader(1, request.getCurrentRequestId(), request.getBatchId(), request.getRequestCode());
            managementRequestHeader.write(output);
            request.writeRequest(this, (FlushableDataOutput)output);
        }
        catch (Exception e) {
            responseHandler.removeCloseHandler();
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
        finally {
            IoUtils.safeClose((Closeable)output);
        }
    }

    private void addCloseHandler(ManagementRequest<?> request, ManagementResponseHandler<?> responseHandler) {
        CloseHandler<Channel> closeHandler = request.getRequestCloseHandler();
        if (closeHandler != null) {
            HandleableCloseable.Key closeKey = this.addCloseHandler(closeHandler);
            responseHandler.setCloseKey(closeKey);
        }
    }

    void throwFormattedException(Exception e) throws IOException {
        if (e instanceof IOException) {
            throw (IOException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new IOException(e);
    }

    void ping(long timeOut) {
        if (this.awaitingPong.get()) {
            if (System.currentTimeMillis() - this.lastResponseReceived > timeOut) {
                try {
                    ProtocolLogger.ROOT_LOGGER.tracef("Closing %s did not receive any pong within %dms", this, timeOut);
                    this.close();
                }
                catch (IOException ignore) {}
            }
        } else {
            ProtocolLogger.ROOT_LOGGER.tracef("No data received recently on %s, pinging to determine if the other end is alive", this);
            this.awaitingPong.set(true);
            ManagementPingHeader pingHeader = new ManagementPingHeader(1);
            this.sendHeaderAndCloseOnError(pingHeader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeaderAndCloseOnError(ManagementProtocolHeader header) {
        boolean ok = false;
        try {
            SimpleDataOutput out = new SimpleDataOutput(Marshalling.createByteOutput((OutputStream)this.writeMessage()));
            try {
                header.write((DataOutput)out);
                ok = true;
            }
            finally {
                IoUtils.safeClose((Closeable)out);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (!ok) {
                ProtocolLogger.ROOT_LOGGER.tracef("Error sending 0x%X on %s, closing channel", header.getType(), this);
                IoUtils.safeClose((Closeable)((Object)this));
            }
        }
    }

    private class ResponseReceiver {
        private final Map<Integer, ManagementResponseHandler<?>> responseHandlers = Collections.synchronizedMap(new HashMap());

        private ResponseReceiver() {
        }

        private void registerResponseHandler(int requestId, ManagementResponseHandler<?> handler) throws IOException {
            if (this.responseHandlers.put(requestId, handler) != null) {
                throw ProtocolMessages.MESSAGES.responseHandlerAlreadyRegistered();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleResponse(ManagementResponseHeader header, DataInput input) throws IOException {
            ProtocolLogger.ROOT_LOGGER.tracef("%s handling response %d", ManagementChannel.this, header.getResponseId());
            ManagementResponseHandler<?> responseHandler = this.responseHandlers.remove(header.getResponseId());
            if (responseHandler == null) {
                throw ProtocolMessages.MESSAGES.responseHandlerNotFound(header.getResponseId());
            }
            try {
                responseHandler.setContextInfo(header, ManagementChannel.this);
                responseHandler.readResponse(input);
                ProtocolUtils.expectHeader(input, 36);
            }
            catch (Exception e) {
                ManagementChannel.this.throwFormattedException(e);
            }
            finally {
                responseHandler.removeCloseHandler();
                ProtocolLogger.ROOT_LOGGER.tracef("%s handled response %d", ManagementChannel.this, header.getResponseId());
            }
        }

        static /* synthetic */ void access$400(ResponseReceiver x0, ManagementResponseHeader x1, DataInput x2) throws IOException {
            x0.handleResponse(x1, x2);
        }
    }

    private class RequestReceiver {
        private volatile ManagementOperationHandler operationHandler;

        private RequestReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManagementRequestHandler readRequest(ManagementRequestHeader header, DataInput input) throws IOException {
            ProtocolLogger.ROOT_LOGGER.tracef("%s reading request %d(%d)", ManagementChannel.this, header.getBatchId(), header.getRequestId());
            Throwable error = null;
            try {
                ManagementRequestHandler requestHandler = this.getRequestHandler(header);
                requestHandler.setContextInfo(ManagementChannel.this, header);
                requestHandler.readRequest(input);
                ProtocolUtils.expectHeader(input, 21);
                ManagementRequestHandler managementRequestHandler = requestHandler;
                return managementRequestHandler;
            }
            finally {
                if (error == null) {
                    ProtocolLogger.ROOT_LOGGER.tracef("%s finished reading request %d", ManagementChannel.this, header.getBatchId());
                } else {
                    ProtocolLogger.ROOT_LOGGER.tracef(error, "%s finished reading request %d with error", ManagementChannel.this, header.getBatchId());
                }
            }
        }

        private void processRequest(ManagementRequestHeader requestHeader, ManagementRequestHandler requestHandler) throws RequestProcessingException {
            ProtocolLogger.ROOT_LOGGER.tracef("%s processing request %d", ManagementChannel.this, requestHeader.getBatchId());
            try {
                requestHandler.processRequest();
                ProtocolLogger.ROOT_LOGGER.tracef("%s finished processing request %d", ManagementChannel.this, requestHeader.getBatchId());
            }
            catch (Exception e) {
                ProtocolLogger.ROOT_LOGGER.tracef(e, "%s finished processing request %d with error", ManagementChannel.this, requestHeader.getBatchId());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeResponse(ManagementRequestHeader requestHeader, ManagementRequestHandler requestHandler, Exception error) {
            FlushableDataOutputImpl output;
            ProtocolLogger.ROOT_LOGGER.tracef("%s writing response %d", ManagementChannel.this, requestHeader.getBatchId());
            try {
                output = FlushableDataOutputImpl.create(ManagementChannel.this.writeMessage());
            }
            catch (Exception e) {
                ProtocolLogger.ROOT_LOGGER.tracef(e, "%s could not open output stream for request %d", ManagementChannel.this, requestHeader.getBatchId());
                return;
            }
            try {
                this.writeResponseHeader(requestHeader, output, error);
                if (error == null && requestHandler != null) {
                    requestHandler.writeResponse(output);
                }
                output.writeByte(36);
            }
            catch (Exception e) {
                ProtocolLogger.ROOT_LOGGER.tracef(e, "%s finished writing response %d with error", ManagementChannel.this, requestHeader.getBatchId());
            }
            finally {
                ProtocolLogger.ROOT_LOGGER.tracef("%s finished writing response %d", ManagementChannel.this, requestHeader.getBatchId());
                IoUtils.safeClose((Closeable)output);
            }
        }

        private ManagementRequestHandler getRequestHandler(ManagementRequestHeader header) throws IOException {
            try {
                ManagementOperationHandler operationHandler = this.operationHandler;
                if (operationHandler == null) {
                    throw ProtocolMessages.MESSAGES.operationHandlerNotSet();
                }
                ManagementRequestHandler requestHandler = operationHandler.getRequestHandler(header.getOperationId());
                if (requestHandler == null) {
                    throw ProtocolMessages.MESSAGES.requestHandlerIdNotFound(header.getOperationId(), operationHandler);
                }
                return requestHandler;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        private void writeResponseHeader(ManagementRequestHeader header, DataOutput output, Exception exception) throws IOException {
            int workingVersion = Math.min(1, header.getVersion());
            try {
                ManagementResponseHeader responseHeader = new ManagementResponseHeader(workingVersion, header.getRequestId(), this.formatException(exception));
                responseHeader.write(output);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw ProtocolMessages.MESSAGES.failedToWriteManagementResponseHeaders(t);
            }
        }

        private void setOperationHandler(ManagementOperationHandler operationHandler) {
            this.operationHandler = operationHandler;
        }

        private String formatException(Exception exception) {
            if (exception == null) {
                return null;
            }
            return exception.getMessage();
        }

        static /* synthetic */ ManagementRequestHandler access$300(RequestReceiver x0, ManagementRequestHeader x1, DataInput x2) throws IOException {
            return x0.readRequest(x1, x2);
        }

        static /* synthetic */ void access$500(RequestReceiver x0, ManagementRequestHeader x1, ManagementRequestHandler x2) throws RequestProcessingException {
            x0.processRequest(x1, x2);
        }

        static /* synthetic */ void access$600(RequestReceiver x0, ManagementRequestHeader x1, ManagementRequestHandler x2, Exception x3) {
            x0.writeResponse(x1, x2, x3);
        }
    }
}

