/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.model.AbstractSubsystemElement;
import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorElement;
import org.jboss.as.remoting.Namespace;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class RemotingSubsystemElement
extends AbstractSubsystemElement<RemotingSubsystemElement> {
    private static final long serialVersionUID = 8225457441023207312L;
    public static final ServiceName JBOSS_REMOTING = ServiceName.JBOSS.append(new String[]{"remoting"});
    public static final ServiceName JBOSS_REMOTING_ENDPOINT = JBOSS_REMOTING.append(new String[]{"endpoint"});
    private final SortedMap<String, ConnectorElement> connectors = new TreeMap<String, ConnectorElement>();
    private String threadPoolName;
    public static final String NAMESPACE_1_0 = "urn:jboss:domain:remoting:1.0";
    public static final String NAMESPACE = "urn:jboss:domain:remoting:1.0";
    public static final Set<String> NAMESPACES = Collections.singleton("urn:jboss:domain:remoting:1.0");

    public RemotingSubsystemElement() {
        super(Namespace.REMOTING_1_0.getUriString());
    }

    protected Class<RemotingSubsystemElement> getElementClass() {
        return RemotingSubsystemElement.class;
    }

    public void writeContent(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        streamWriter.writeAttribute(Attribute.THREAD_POOL.getLocalName(), this.threadPoolName);
        for (ConnectorElement element : this.connectors.values()) {
            streamWriter.writeStartElement("connector");
            element.writeContent(streamWriter);
        }
        streamWriter.writeEndElement();
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    void setThreadPoolName(String threadPoolName) {
        this.threadPoolName = threadPoolName;
    }

    ConnectorElement getConnector(String name) {
        return (ConnectorElement)((Object)this.connectors.get(name));
    }

    String addConnector(ConnectorElement element) {
        String name = element.getName();
        if (this.connectors.containsKey(name)) {
            throw new IllegalArgumentException("A connector with this name already exists");
        }
        this.connectors.put(name, element);
        return name;
    }

    ConnectorElement removeConnector(String name) {
        ConnectorElement element = (ConnectorElement)((Object)this.connectors.remove(name));
        if (element == null) {
            throw new IllegalArgumentException("No such connector exists");
        }
        return element;
    }

    protected void getUpdates(List<? super AbstractSubsystemUpdate<RemotingSubsystemElement, ?>> list) {
    }

    protected boolean isEmpty() {
        return false;
    }

    protected RemotingSubsystemAdd getAdd() {
        return new RemotingSubsystemAdd(this.threadPoolName);
    }

    protected <P> void applyRemove(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceContainer container = updateContext.getServiceContainer();
        ServiceController controller = container.getService(RemotingServices.ENDPOINT);
        if (controller != null) {
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    ConnectorElement addConnector(String name, String socketBinding) {
        if (this.connectors.containsKey(name)) {
            return null;
        }
        ConnectorElement connector = new ConnectorElement(name, socketBinding);
        this.connectors.put(name, connector);
        return connector;
    }
}

