/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.model.AbstractSubsystemUpdate;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.remoting.AbstractRemotingSubsystemUpdate;
import org.jboss.as.remoting.AddConnectorUpdate;
import org.jboss.as.remoting.ConnectorElement;
import org.jboss.as.remoting.RemotingSubsystemElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public final class RemoveConnectorUpdate
extends AbstractRemotingSubsystemUpdate<Void> {
    private static final long serialVersionUID = -8965990593053845956L;
    private final String name;

    public RemoveConnectorUpdate(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.name = name;
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> resultHandler, P param) {
        ServiceController controller = updateContext.getServiceContainer().getService(ConnectorElement.connectorName(this.name));
        if (controller == null) {
            resultHandler.handleSuccess(null, param);
        } else {
            controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(resultHandler, param));
            controller.setMode(ServiceController.Mode.REMOVE);
        }
    }

    public AbstractSubsystemUpdate<RemotingSubsystemElement, ?> getCompensatingUpdate(RemotingSubsystemElement subSystem) {
        ConnectorElement original = subSystem.getConnector(this.name);
        if (original == null) {
            throw new IllegalStateException("null connector name");
        }
        AddConnectorUpdate update = new AddConnectorUpdate(original.getName(), original.getSocketBinding());
        update.setAuthenticationProvider(original.getAuthenticationProvider());
        update.setSaslElement(original.getSaslElement());
        return update;
    }

    protected void applyUpdate(RemotingSubsystemElement element) throws UpdateFailedException {
        ConnectorElement connector = element.removeConnector(this.name);
        if (connector == null) {
            throw new IllegalStateException("failed to remove connector " + this.name);
        }
    }
}

