/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.concurrent.Executor;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.remoting.EndpointService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.inject.CastingInjector;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.xnio.OptionMap;

class RemotingSubsystemAdd
implements ModelAddOperationHandler {
    static final OperationHandler INSTANCE = new RemotingSubsystemAdd();

    RemotingSubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        final String threadPoolName = operation.require("thread-pool").asString();
        context.getSubModel().get("thread-pool").set(threadPoolName);
        context.getSubModel().get("connector").setEmptyObject();
        ModelNode compensating = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    EndpointService endpointService = new EndpointService();
                    endpointService.setOptionMap(OptionMap.EMPTY);
                    Injector<Executor> executorInjector = endpointService.getExecutorInjector();
                    context.getServiceTarget().addService(RemotingServices.ENDPOINT, (Service)endpointService).addDependency(ThreadsServices.executorName((String)threadPoolName), (Injector)new CastingInjector(executorInjector, Executor.class)).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

