/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.controller.remote.ManagementOperationHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelFactory;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.OpenListener;
import org.jboss.remoting3.Registration;
import org.xnio.OptionMap;

public class ChannelOpenListenerService
implements Service<Void>,
OpenListener {
    private final Logger log = Logger.getLogger((String)"org.jboss.as.remoting");
    private final InjectedValue<Endpoint> endpointValue = new InjectedValue();
    private final InjectedValue<ManagementOperationHandlerFactory> operationHandlerFactoryValue = new InjectedValue();
    private final String channelName;
    private final OptionMap optionMap;
    private final Set<ManagementChannel> channels = Collections.synchronizedSet(new HashSet());
    private volatile Registration registration;
    private final AtomicBoolean closed = new AtomicBoolean();

    public ChannelOpenListenerService(String channelName, OptionMap optionMap) {
        this.channelName = channelName;
        this.optionMap = optionMap;
    }

    public ServiceName getServiceName() {
        return RemotingServices.channelServiceName(this.channelName);
    }

    public InjectedValue<Endpoint> getEndpointInjector() {
        return this.endpointValue;
    }

    public InjectedValue<ManagementOperationHandlerFactory> getOperationHandlerInjector() {
        return this.operationHandlerFactoryValue;
    }

    public Void getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.log.debugf("Registering channel listener for %s", (Object)this.channelName);
            this.registration = ((Endpoint)this.endpointValue.getValue()).registerService(this.channelName, (OpenListener)this, this.optionMap);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.close();
        }
        Set<ManagementChannel> set = this.channels;
        synchronized (set) {
            for (ManagementChannel channel : this.channels) {
                try {
                    channel.sendByeBye();
                }
                catch (IOException e) {}
            }
        }
    }

    public void channelOpened(Channel channel) {
        ManagementOperationHandler handler = ((ManagementOperationHandlerFactory)this.operationHandlerFactoryValue.getValue()).createOperationHandler();
        final ManagementChannel managementChannel = new ManagementChannelFactory(handler).create(this.channelName, channel);
        this.channels.add(managementChannel);
        this.log.tracef("Opened %s: %s with handler %s", (Object)this.channelName, (Object)managementChannel, (Object)handler);
        managementChannel.startReceiving();
        channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

            public void handleClose(Channel closed, IOException exception) {
                ChannelOpenListenerService.this.channels.remove(managementChannel);
                try {
                    managementChannel.sendByeBye();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ChannelOpenListenerService.this.log.tracef("Handling close for %s", (Object)managementChannel);
            }
        });
    }

    public void registrationTerminated() {
    }
}

