/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.RemotingSubsystemAdd;
import org.jboss.as.remoting.RemotingSubsystemRemove;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public class RemotingSubsystemRootResource
extends SimpleResourceDefinition {
    static final RemotingSubsystemRootResource INSTANCE = new RemotingSubsystemRootResource();
    static final SimpleAttributeDefinition WORKER_READ_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-read-threads", 1);
    static final SimpleAttributeDefinition WORKER_TASK_CORE_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-task-core-threads", 4);
    static final SimpleAttributeDefinition WORKER_TASK_KEEPALIVE = RemotingSubsystemRootResource.createIntAttribute("worker-task-keepalive", 60);
    static final SimpleAttributeDefinition WORKER_TASK_LIMIT = RemotingSubsystemRootResource.createIntAttribute("worker-task-limit", 16384);
    static final SimpleAttributeDefinition WORKER_TASK_MAX_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-task-max-threads", 16);
    static final SimpleAttributeDefinition WORKER_WRITE_THREADS = RemotingSubsystemRootResource.createIntAttribute("worker-write-threads", 1);

    private RemotingSubsystemRootResource() {
        super(PathElement.pathElement((String)"subsystem", (String)"remoting"), RemotingExtension.getResourceDescriptionResolver("remoting"), (OperationStepHandler)RemotingSubsystemAdd.INSTANCE, (OperationStepHandler)RemotingSubsystemRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_READ_THREADS);
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_TASK_CORE_THREADS);
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_TASK_KEEPALIVE);
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_TASK_LIMIT);
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_TASK_MAX_THREADS);
        this.registerReadWriteIntAttribute(resourceRegistration, (AttributeDefinition)WORKER_WRITE_THREADS);
    }

    private void registerReadWriteIntAttribute(ManagementResourceRegistration resourceRegistration, AttributeDefinition attr) {
        resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)new ThreadWriteAttributeHandler(attr));
    }

    private static SimpleAttributeDefinition createIntAttribute(String name, int defaultValue) {
        return SimpleAttributeDefinitionBuilder.create((String)name, (ModelType)ModelType.INT, (boolean)true).setDefaultValue(new ModelNode().set(defaultValue)).setValidator((ParameterValidator)new IntRangeValidator(1)).build();
    }

    private static class ThreadWriteAttributeHandler
    extends RestartParentWriteAttributeHandler {
        ThreadWriteAttributeHandler(AttributeDefinition definition) {
            super("subsystem", definition);
        }

        protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
            RemotingSubsystemAdd.INSTANCE.launchServices(context, parentModel, verificationHandler, null);
        }

        protected ServiceName getParentServiceName(PathAddress parentAddress) {
            return RemotingServices.SUBSYSTEM_ENDPOINT;
        }
    }
}

