/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.security.ServerAuthenticationProvider;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;
import org.xnio.Xnio;
import org.xnio.ssl.JsseXnioSsl;
import org.xnio.ssl.XnioSsl;

public class RealmSecurityProvider
implements RemotingSecurityProvider {
    static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    static final String PRE_DIGESTED_PROPERTY = "org.jboss.sasl.digest.pre_digested";
    static final String LOCAL_DEFAULT_USER = "jboss.sasl.local-user.default-user";
    static final String LOCAL_USER_CHALLENGE_PATH = "jboss.sasl.local-user.challenge-path";
    static final String ANONYMOUS = "ANONYMOUS";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String EXTERNAL = "EXTERNAL";
    static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    static final String PLAIN = "PLAIN";
    private static final String DOLLAR_LOCAL = "$local";
    private final SecurityRealm realm;
    private final CallbackHandler serverCallbackHandler;
    private final String tokensDir;

    public RealmSecurityProvider(SecurityRealm realm, CallbackHandler serverCallbackHandler, String tokensDir) {
        this.realm = realm;
        this.serverCallbackHandler = serverCallbackHandler;
        this.tokensDir = tokensDir;
    }

    @Override
    public OptionMap getOptionMap() {
        LinkedList<String> mechanisms = new LinkedList<String>();
        HashSet<Property> properties = new HashSet<Property>();
        OptionMap.Builder builder = OptionMap.builder();
        mechanisms.add(JBOSS_LOCAL_USER);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, false);
        properties.add(Property.of((String)LOCAL_DEFAULT_USER, (String)DOLLAR_LOCAL));
        if (this.tokensDir != null) {
            properties.add(Property.of((String)LOCAL_USER_CHALLENGE_PATH, (String)this.tokensDir));
        }
        if (this.digestMd5Supported()) {
            mechanisms.add(DIGEST_MD5);
            properties.add(Property.of((String)REALM_PROPERTY, (String)this.realm.getName()));
            if (RealmSecurityProvider.contains(DigestHashCallback.class, this.realm.getCallbackHandler().getSupportedCallbacks())) {
                properties.add(Property.of((String)PRE_DIGESTED_PROPERTY, (String)Boolean.TRUE.toString()));
            }
        } else if (this.plainSupported()) {
            mechanisms.add(PLAIN);
        } else if (this.realm == null) {
            mechanisms.add(ANONYMOUS);
            builder.set(Options.SASL_POLICY_NOANONYMOUS, false);
        } else {
            throw new IllegalStateException("A security realm has been specified but no supported mechanism identified.");
        }
        SslMode sslMode = this.getSslMode();
        switch (sslMode) {
            case OFF: {
                builder.set(Options.SSL_ENABLED, false);
                break;
            }
            case TRANSPORT_ONLY: {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
                break;
            }
            case CLIENT_AUTH_REQUESTED: {
                builder.set(Options.SSL_ENABLED, true);
                builder.set(Options.SSL_STARTTLS, true);
                mechanisms.add(0, EXTERNAL);
                builder.set(Options.SSL_CLIENT_AUTH_MODE, (Object)SslClientAuthMode.REQUESTED);
            }
        }
        builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(mechanisms));
        builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(properties));
        return builder.getMap();
    }

    @Override
    public ServerAuthenticationProvider getServerAuthenticationProvider() {
        return new ServerAuthenticationProvider(){

            public CallbackHandler getCallbackHandler(String mechanismName) {
                return RealmSecurityProvider.this.getCallbackHandler(mechanismName);
            }
        };
    }

    @Override
    public XnioSsl getXnioSsl() {
        SSLContext sslContext;
        if (this.realm == null || (sslContext = this.realm.getSSLContext()) == null) {
            return null;
        }
        return new JsseXnioSsl(Xnio.getInstance((ClassLoader)Remoting.class.getClassLoader()), OptionMap.EMPTY, sslContext);
    }

    public CallbackHandler getCallbackHandler(String mechanismName) {
        if (ANONYMOUS.equals(mechanismName) && this.realm == null) {
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    int i$ = 0;
                    Callback[] arr$ = callbacks;
                    int len$ = arr$.length;
                    if (i$ < len$) {
                        Callback current = arr$[i$];
                        throw new UnsupportedCallbackException(current, "ANONYMOUS mechanism so not expecting a callback");
                    }
                }
            };
        }
        if (JBOSS_LOCAL_USER.equals(mechanismName)) {
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (current instanceof NameCallback) {
                            NameCallback ncb = (NameCallback)current;
                            if (RealmSecurityProvider.DOLLAR_LOCAL.equals(ncb.getDefaultName())) continue;
                            throw new SaslException("Only $local user is acceptable.");
                        }
                        if (current instanceof AuthorizeCallback) {
                            AuthorizeCallback acb = (AuthorizeCallback)current;
                            acb.setAuthorized(acb.getAuthenticationID().equals(acb.getAuthorizationID()));
                            continue;
                        }
                        throw new UnsupportedCallbackException(current);
                    }
                }
            };
        }
        if (EXTERNAL.equals(mechanismName)) {
            return new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback current : callbacks) {
                        if (!(current instanceof AuthorizeCallback)) {
                            throw new UnsupportedCallbackException(current);
                        }
                        AuthorizeCallback acb = (AuthorizeCallback)current;
                        acb.setAuthorized(acb.getAuthenticationID().equals(acb.getAuthorizationID()));
                    }
                }
            };
        }
        if (!(DIGEST_MD5.equals(mechanismName) && this.digestMd5Supported() || PLAIN.equals(mechanismName) && this.plainSupported())) {
            return null;
        }
        DomainCallbackHandler realmCallbackHandler = this.realm.getCallbackHandler();
        if (this.serverCallbackHandler == null) {
            return realmCallbackHandler;
        }
        return new CallbackHandler((CallbackHandler)realmCallbackHandler){
            final /* synthetic */ CallbackHandler val$realmCallbackHandler;
            {
                this.val$realmCallbackHandler = callbackHandler;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                RealmSecurityProvider.this.serverCallbackHandler.handle(callbacks);
                if (!this.handled(callbacks)) {
                    this.val$realmCallbackHandler.handle(callbacks);
                }
            }

            private boolean handled(Callback[] callbacks) {
                for (Callback current : callbacks) {
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        char[] password = pcb.getPassword();
                        return password != null && password.length > 0;
                    }
                    if (current instanceof VerifyPasswordCallback) {
                        return ((VerifyPasswordCallback)current).isVerified();
                    }
                    if (!(current instanceof DigestHashCallback)) continue;
                    return ((DigestHashCallback)current).getHash() != null;
                }
                return false;
            }
        };
    }

    private SslMode getSslMode() {
        if (this.realm == null || this.realm.getSSLContext() == null) {
            return SslMode.OFF;
        }
        if (this.realm.hasTrustStore()) {
            return SslMode.CLIENT_AUTH_REQUESTED;
        }
        return SslMode.TRANSPORT_ONLY;
    }

    private boolean digestMd5Supported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmSecurityProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(RealmCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(PasswordCallback.class, callbacks) && !RealmSecurityProvider.contains(DigestHashCallback.class, callbacks)) {
            return false;
        }
        return RealmSecurityProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private boolean plainSupported() {
        if (this.realm == null) {
            return false;
        }
        Class[] callbacks = this.realm.getCallbackHandler().getSupportedCallbacks();
        if (!RealmSecurityProvider.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!RealmSecurityProvider.contains(VerifyPasswordCallback.class, callbacks)) {
            return false;
        }
        return RealmSecurityProvider.contains(AuthorizeCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    private static enum SslMode {
        OFF,
        TRANSPORT_ONLY,
        CLIENT_AUTH_REQUESTED;

    }
}

