/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.File;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.remoting.RealmSecurityProvider;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.RemotingSecurityProvider;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class RealmSecurityProviderService
implements Service<RemotingSecurityProvider> {
    private final InjectedValue<SecurityRealm> securityRealmInjectedValue = new InjectedValue();
    private final InjectedValue<CallbackHandler> serverCallbackValue = new InjectedValue();
    private final InjectedValue<String> tmpDirValue = new InjectedValue();
    private volatile RemotingSecurityProvider securityProvider = null;
    private static final ServiceName BASE_NAME = RemotingServices.REMOTING_BASE.append(new String[]{"authentication_provider"});

    public static ServiceName createName(String connectorName) {
        return BASE_NAME.append(new String[]{connectorName});
    }

    public void start(StartContext startContext) throws StartException {
        String path = (String)this.tmpDirValue.getValue();
        File authDir = new File(path, "auth");
        if (authDir.exists()) {
            if (!authDir.isDirectory()) {
                throw RemotingMessages.MESSAGES.unableToCreateTempDirForAuthTokensFileExists();
            }
        } else if (!authDir.mkdirs()) {
            if (!authDir.isDirectory()) {
                throw RemotingMessages.MESSAGES.unableToCreateAuthDir(authDir.getAbsolutePath());
            }
        } else {
            authDir.setWritable(false, false);
            authDir.setWritable(true, true);
            authDir.setReadable(false, false);
            authDir.setReadable(true, true);
            authDir.setExecutable(false, false);
            authDir.setExecutable(true, true);
        }
        this.securityProvider = new RealmSecurityProvider((SecurityRealm)this.securityRealmInjectedValue.getOptionalValue(), (CallbackHandler)this.serverCallbackValue.getOptionalValue(), authDir.getAbsolutePath());
    }

    public void stop(StopContext stopContext) {
        this.securityProvider = null;
    }

    public RemotingSecurityProvider getValue() throws IllegalStateException, IllegalArgumentException {
        return this.securityProvider;
    }

    public InjectedValue<SecurityRealm> getSecurityRealmInjectedValue() {
        return this.securityRealmInjectedValue;
    }

    public InjectedValue<CallbackHandler> getServerCallbackValue() {
        return this.serverCallbackValue;
    }

    public InjectedValue<String> getTmpDirValue() {
        return this.tmpDirValue;
    }
}

