/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorAdd;
import org.jboss.as.remoting.ConnectorRemove;
import org.jboss.as.remoting.PropertyResource;
import org.jboss.as.remoting.RemotingExtension;
import org.jboss.as.remoting.RemotingMessages;
import org.jboss.as.remoting.SaslPolicyResource;
import org.jboss.as.remoting.SaslResource;
import org.jboss.as.remoting.SecurityActions;
import org.jboss.as.remoting.WrappedAttributeMarshaller;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Property;
import org.xnio.Sequence;
import org.xnio.sasl.SaslQop;
import org.xnio.sasl.SaslStrength;

public class ConnectorResource
extends SimpleResourceDefinition {
    static final PathElement PATH = PathElement.pathElement((String)"connector");
    static final ConnectorResource INSTANCE = new ConnectorResource();
    static final SimpleAttributeDefinition AUTHENTICATION_PROVIDER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("authentication-provider", ModelType.STRING).setDefaultValue(null).setAllowNull(true).setAttributeMarshaller((AttributeMarshaller)new WrappedAttributeMarshaller(Attribute.NAME))).build();
    static final SimpleAttributeDefinition SOCKET_BINDING = new SimpleAttributeDefinition("socket-binding", ModelType.STRING, false);
    static final SimpleAttributeDefinition SECURITY_REALM = new SimpleAttributeDefinitionBuilder("security-realm", ModelType.STRING, true).setValidator((ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false)).build();

    private ConnectorResource() {
        super(PATH, RemotingExtension.getResourceDescriptionResolver("connector"), (OperationStepHandler)ConnectorAdd.INSTANCE, (OperationStepHandler)ConnectorRemove.INSTANCE);
    }

    protected static OptionMap getFullOptions(OperationContext context, ModelNode fullModel) throws OperationFailedException {
        ModelNode security;
        OptionMap.Builder builder = OptionMap.builder();
        ModelNode properties = fullModel.get("property");
        if (properties.isDefined() && properties.asInt() > 0) {
            ConnectorResource.addOptions(context, properties, builder);
        }
        if (fullModel.hasDefined("security") && (security = fullModel.require("security")).hasDefined("sasl")) {
            ModelNode sasl = security.require("sasl");
            ConnectorResource.addSasl(context, sasl, builder);
        }
        return builder.getMap();
    }

    protected static OptionMap getOptions(OperationContext context, ModelNode properties) throws OperationFailedException {
        if (properties.isDefined() && properties.asInt() > 0) {
            OptionMap.Builder builder = OptionMap.builder();
            ConnectorResource.addOptions(context, properties, builder);
            return builder.getMap();
        }
        return OptionMap.EMPTY;
    }

    private static void addSasl(OperationContext context, ModelNode sasl, OptionMap.Builder builder) throws OperationFailedException {
        ModelNode saslPolicy;
        if (sasl.hasDefined("include-mechanisms")) {
            builder.set(Options.SASL_MECHANISMS, (Object)Sequence.of(ConnectorResource.asStringSet(sasl.get("include-mechanisms"))));
        }
        if (sasl.hasDefined("qop")) {
            builder.set(Options.SASL_QOP, (Object)Sequence.of(ConnectorResource.asQopSet(sasl.get("qop"))));
        }
        if (sasl.hasDefined("strength")) {
            ModelNode strength = sasl.get("strength");
            for (ModelNode current : strength.asList()) {
                builder.set(Options.SASL_STRENGTH, (Object)ConnectorResource.strengthFromString(current.asString()));
            }
        }
        if (sasl.hasDefined("server-auth")) {
            builder.set(Options.SASL_SERVER_AUTH, SaslResource.SERVER_AUTH_ATTRIBUTE.resolveModelAttribute(context, sasl).asBoolean());
        }
        if (sasl.hasDefined("reuse-session")) {
            builder.set(Options.SASL_REUSE, SaslResource.REUSE_SESSION_ATTRIBUTE.resolveModelAttribute(context, sasl).asBoolean());
        }
        if (sasl.hasDefined("sasl-policy") && (saslPolicy = sasl.get("sasl-policy")).hasDefined("policy")) {
            ModelNode policy = saslPolicy.get("policy");
            if (policy.hasDefined(SaslPolicyResource.FORWARD_SECRECY.getName())) {
                builder.set(Options.SASL_POLICY_FORWARD_SECRECY, SaslPolicyResource.FORWARD_SECRECY.resolveModelAttribute(context, policy).asBoolean());
            }
            if (policy.hasDefined(SaslPolicyResource.NO_ACTIVE.getName())) {
                builder.set(Options.SASL_POLICY_NOACTIVE, SaslPolicyResource.NO_ACTIVE.resolveModelAttribute(context, policy).asBoolean());
            }
            if (policy.hasDefined(SaslPolicyResource.NO_ANONYMOUS.getName())) {
                builder.set(Options.SASL_POLICY_NOANONYMOUS, SaslPolicyResource.NO_ANONYMOUS.resolveModelAttribute(context, policy).asBoolean());
            }
            if (policy.hasDefined(SaslPolicyResource.NO_DICTIONARY.getName())) {
                builder.set(Options.SASL_POLICY_NODICTIONARY, SaslPolicyResource.NO_DICTIONARY.resolveModelAttribute(context, policy).asBoolean());
            }
            if (policy.hasDefined(SaslPolicyResource.NO_PLAIN_TEXT.getName())) {
                builder.set(Options.SASL_POLICY_NOPLAINTEXT, SaslPolicyResource.NO_PLAIN_TEXT.resolveModelAttribute(context, policy).asBoolean());
            }
            if (policy.hasDefined(SaslPolicyResource.PASS_CREDENTIALS.getName())) {
                builder.set(Options.SASL_POLICY_PASS_CREDENTIALS, SaslPolicyResource.PASS_CREDENTIALS.resolveModelAttribute(context, policy).asBoolean());
            }
        }
        if (sasl.hasDefined("property")) {
            ModelNode property = sasl.get("property");
            List props = property.asPropertyList();
            ArrayList<Property> converted = new ArrayList<Property>(props.size());
            for (org.jboss.dmr.Property current : props) {
                converted.add(Property.of((String)current.getName(), (String)PropertyResource.VALUE.resolveModelAttribute(context, current.getValue()).asString()));
            }
            builder.set(Options.SASL_PROPERTIES, (Object)Sequence.of(converted));
        }
    }

    private static void addOptions(OperationContext context, ModelNode properties, OptionMap.Builder builder) throws OperationFailedException {
        ClassLoader loader = SecurityActions.getClassLoader(ConnectorResource.class);
        for (org.jboss.dmr.Property property : properties.asPropertyList()) {
            String name = property.getName();
            if (!name.contains(".")) {
                name = "org.xnio.Options." + name;
            }
            Option option = Option.fromString((String)name, (ClassLoader)loader);
            String value = PropertyResource.VALUE.resolveModelAttribute(context, property.getValue()).asString();
            builder.set(option, option.parseValue(value, loader));
        }
    }

    private static Collection<String> asStringSet(ModelNode node) {
        HashSet<String> set = new HashSet<String>();
        for (ModelNode element : node.asList()) {
            set.add(element.asString());
        }
        return set;
    }

    private static Collection<SaslQop> asQopSet(ModelNode node) {
        HashSet<SaslQop> set = new HashSet<SaslQop>();
        for (ModelNode element : node.asList()) {
            set.add(SaslQop.fromString((String)element.asString()));
        }
        return set;
    }

    private static SaslStrength strengthFromString(String name) {
        if ("low".equals(name)) {
            return SaslStrength.LOW;
        }
        if ("medium".equals(name)) {
            return SaslStrength.MEDIUM;
        }
        if ("high".equals(name)) {
            return SaslStrength.HIGH;
        }
        throw RemotingMessages.MESSAGES.illegalStrength(name);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{AUTHENTICATION_PROVIDER, SOCKET_BINDING, SECURITY_REALM});
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)AUTHENTICATION_PROVIDER, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SOCKET_BINDING, null, (OperationStepHandler)writeHandler);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)SECURITY_REALM, null, (OperationStepHandler)writeHandler);
    }
}

