/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.ModelQueryOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.security.Namespace;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.SecurityDomainRemove;
import org.jboss.as.security.SecuritySubsystemAdd;
import org.jboss.as.security.SecuritySubsystemDescriptions;
import org.jboss.as.security.SecuritySubsystemParser;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class SecurityExtension
implements Extension {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.security");
    public static final ServiceName JBOSS_SECURITY = ServiceName.JBOSS.append(new String[]{"security"});
    public static final String SUBSYSTEM_NAME = "security";
    private static final SecuritySubsystemParser PARSER = new SecuritySubsystemParser();

    public void initialize(ExtensionContext context) {
        log.debug((Object)"Initializing Security Extension");
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(SecuritySubsystemDescriptions.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)SecuritySubsystemAdd.INSTANCE, SecuritySubsystemDescriptions.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)SecurityDescribeHandler.INSTANCE, SecuritySubsystemDescriptions.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        ModelNodeRegistration securityDomain = registration.registerSubModel(PathElement.pathElement((String)"security-domain"), SecuritySubsystemDescriptions.SECURITY_DOMAIN);
        securityDomain.registerOperationHandler("add", (OperationHandler)SecurityDomainAdd.INSTANCE, SecuritySubsystemDescriptions.SECURITY_DOMAIN_ADD, false);
        securityDomain.registerOperationHandler("remove", (OperationHandler)SecurityDomainRemove.INSTANCE, SecuritySubsystemDescriptions.SECURITY_DOMAIN_REMOVE, false);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUriString(), (XMLElementReader)PARSER);
    }

    private static class SecurityDescribeHandler
    implements ModelQueryOperationHandler {
        static final SecurityDescribeHandler INSTANCE = new SecurityDescribeHandler();

        private SecurityDescribeHandler() {
        }

        public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) {
            ModelNode model = context.getSubModel();
            ModelNode subsystem = new ModelNode();
            subsystem.get("operation").set("add");
            subsystem.get("address").add("subsystem", SecurityExtension.SUBSYSTEM_NAME);
            if (model.hasDefined("authentication-manager-class-name")) {
                subsystem.get("authentication-manager-class-name").set(model.get("authentication-manager-class-name"));
            }
            if (model.hasDefined("deep-copy-subject-mode")) {
                subsystem.get("deep-copy-subject-mode").set(model.get("deep-copy-subject-mode"));
            }
            if (model.hasDefined("default-callback-handler-class-name")) {
                subsystem.get("default-callback-handler-class-name").set(model.get("default-callback-handler-class-name"));
            }
            if (model.hasDefined("subject-factory-class-name")) {
                subsystem.get("subject-factory-class-name").set(model.get("subject-factory-class-name"));
            }
            if (model.hasDefined("authorization-manager-class-name")) {
                subsystem.get("authorization-manager-class-name").set(model.get("authorization-manager-class-name"));
            }
            if (model.hasDefined("audit-manager-class-name")) {
                subsystem.get("audit-manager-class-name").set(model.get("audit-manager-class-name"));
            }
            if (model.hasDefined("identity-trust-manager-class-name")) {
                subsystem.get("identity-trust-manager-class-name").set(model.get("identity-trust-manager-class-name"));
            }
            if (model.hasDefined("mapping-manager-class-name")) {
                subsystem.get("mapping-manager-class-name").set(model.get("mapping-manager-class-name"));
            }
            ModelNode result = new ModelNode();
            result.add(subsystem);
            if (model.hasDefined("security-domain")) {
                for (Property prop : model.get("security-domain").asPropertyList()) {
                    ModelNode addr = subsystem.get("address").clone().add("security-domain", prop.getName());
                    result.add(SecurityDomainAdd.getRecreateOperation(addr, prop.getValue()));
                }
            }
            resultHandler.handleResultFragment(Util.NO_LOCATION, result);
            resultHandler.handleResultComplete();
            return new BasicOperationResult();
        }
    }
}

