/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import javax.security.auth.login.Configuration;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.ModuleName;
import org.jboss.as.security.context.SecurityDomainJndiInjectable;
import org.jboss.as.security.processors.SecurityDependencyProcessor;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityBootstrapService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.BootOperationContext;
import org.jboss.as.server.BootOperationHandler;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.plugins.JBossAuthorizationManager;
import org.jboss.security.plugins.JBossSecuritySubjectFactory;
import org.jboss.security.plugins.audit.JBossAuditManager;
import org.jboss.security.plugins.auth.JaasSecurityManagerBase;
import org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager;
import org.jboss.security.plugins.mapping.JBossMappingManager;

class SecuritySubsystemAdd
implements ModelAddOperationHandler,
BootOperationHandler {
    private static final String AUTHENTICATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JaasSecurityManagerBase.class.getName();
    private static final String CALLBACK_HANDLER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossCallbackHandler.class.getName();
    private static final String AUTHORIZATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuthorizationManager.class.getName();
    private static final String AUDIT_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuditManager.class.getName();
    private static final String IDENTITY_TRUST_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossIdentityTrustManager.class.getName();
    private static final String MAPPING_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossMappingManager.class.getName();
    private static final boolean DEFAULT_DEEP_COPY_OPERATION_MODE = false;
    private static final String SUBJECT_FACTORY = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossSecuritySubjectFactory.class.getName();
    static final SecuritySubsystemAdd INSTANCE = new SecuritySubsystemAdd();

    private SecuritySubsystemAdd() {
    }

    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) {
        boolean deepCopySubject;
        String authenticationManagerClassName = "default";
        String callbackHandlerClassName = "default";
        String subjectFactoryClassName = "default";
        String authorizationManagerClassName = "default";
        String auditManagerClassName = "default";
        String identityTrustManagerClassName = "default";
        String mappingManagerClassName = "default";
        ModelNode subModel = context.getSubModel();
        if (operation.hasDefined("authentication-manager-class-name")) {
            authenticationManagerClassName = operation.get("authentication-manager-class-name").asString();
            subModel.get("authentication-manager-class-name").set(authenticationManagerClassName);
        }
        if (operation.hasDefined("deep-copy-subject-mode")) {
            deepCopySubject = operation.get("deep-copy-subject-mode").asBoolean();
            subModel.get("deep-copy-subject-mode").set(deepCopySubject);
        } else {
            deepCopySubject = false;
        }
        if (operation.hasDefined("default-callback-handler-class-name")) {
            callbackHandlerClassName = operation.get("default-callback-handler-class-name").asString();
            subModel.get("default-callback-handler-class-name").set(callbackHandlerClassName);
        } else {
            callbackHandlerClassName = CALLBACK_HANDLER;
        }
        if (operation.hasDefined("subject-factory-class-name")) {
            subjectFactoryClassName = operation.get("subject-factory-class-name").asString();
            subModel.get("subject-factory-class-name").set(subjectFactoryClassName);
        }
        if (operation.hasDefined("authorization-manager-class-name")) {
            authorizationManagerClassName = operation.get("authorization-manager-class-name").asString();
            subModel.get("authorization-manager-class-name").set(authorizationManagerClassName);
        }
        if (operation.hasDefined("audit-manager-class-name")) {
            auditManagerClassName = operation.get("audit-manager-class-name").asString();
            subModel.get("audit-manager-class-name").set(auditManagerClassName);
        }
        if (operation.hasDefined("identity-trust-manager-class-name")) {
            identityTrustManagerClassName = operation.get("identity-trust-manager-class-name").asString();
            subModel.get("identity-trust-manager-class-name").set(identityTrustManagerClassName);
        }
        if (operation.hasDefined("mapping-manager-class-name")) {
            mappingManagerClassName = operation.get("mapping-manager-class-name").asString();
            subModel.get("mapping-manager-class-name").set(mappingManagerClassName);
        }
        subModel.get("security-domain").setEmptyObject();
        final String resolvedAuthenticationManagerClassName = "default".equals(authenticationManagerClassName) ? AUTHENTICATION_MANAGER : authenticationManagerClassName;
        final String resolvedCallbackHandlerClassName = "default".equals(callbackHandlerClassName) ? CALLBACK_HANDLER : callbackHandlerClassName;
        final String resolvedAuthorizationManagerClassName = "default".equals(authorizationManagerClassName) ? AUTHORIZATION_MANAGER : authorizationManagerClassName;
        final String resolvedAuditManagerClassName = "default".equals(auditManagerClassName) ? AUDIT_MANAGER : auditManagerClassName;
        final String resolvedIdentityTrustManagerClassName = "default".equals(identityTrustManagerClassName) ? IDENTITY_TRUST_MANAGER : identityTrustManagerClassName;
        final String resolvedMappingManagerClassName = "default".equals(mappingManagerClassName) ? MAPPING_MANAGER : mappingManagerClassName;
        final String resolvedSubjectFactoryClassName = "default".equals(subjectFactoryClassName) ? SUBJECT_FACTORY : subjectFactoryClassName;
        if (context instanceof BootOperationContext) {
            final BootOperationContext updateContext = (BootOperationContext)context;
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    updateContext.addDeploymentProcessor(Phase.DEPENDENCIES, 256, (DeploymentUnitProcessor)new SecurityDependencyProcessor());
                    ServiceTarget target = context.getServiceTarget();
                    SecurityBootstrapService bootstrapService = new SecurityBootstrapService();
                    target.addService(SecurityBootstrapService.SERVICE_NAME, (Service)bootstrapService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    SecurityDomainJndiInjectable securityDomainJndiInjectable = new SecurityDomainJndiInjectable();
                    BinderService binderService = new BinderService("jaas");
                    target.addService(ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{"jaas"}), (Service)binderService).addInjection(binderService.getManagedObjectInjector(), (Object)securityDomainJndiInjectable).addDependency(ContextNames.JAVA_CONTEXT_SERVICE_NAME, NamingStore.class, binderService.getNamingStoreInjector()).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainJndiInjectable.getSecurityManagementInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    SecurityManagementService securityManagementService = new SecurityManagementService(resolvedAuthenticationManagerClassName, deepCopySubject, resolvedCallbackHandlerClassName, resolvedAuthorizationManagerClassName, resolvedAuditManagerClassName, resolvedIdentityTrustManagerClassName, resolvedMappingManagerClassName);
                    target.addService(SecurityManagementService.SERVICE_NAME, (Service)securityManagementService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    SubjectFactoryService subjectFactoryService = new SubjectFactoryService(resolvedSubjectFactoryClassName);
                    target.addService(SubjectFactoryService.SERVICE_NAME, (Service)subjectFactoryService).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, subjectFactoryService.getSecurityManagementInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    XMLLoginConfigImpl loginConfig = XMLLoginConfigImpl.getInstance();
                    JaasConfigurationService jaasConfigurationService = new JaasConfigurationService((Configuration)loginConfig);
                    target.addService(JaasConfigurationService.SERVICE_NAME, (Service)jaasConfigurationService).setInitialMode(ServiceController.Mode.ACTIVE).install();
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = Util.getResourceRemoveOperation((ModelNode)operation.require("address"));
        return new BasicOperationResult(compensatingOperation);
    }
}

