/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(final String moduleSpec) throws ModuleLoadException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleClassLoader>(){

                @Override
                public ModuleClassLoader run() throws ModuleLoadException {
                    ModuleLoader loader = Module.getCurrentModuleLoader();
                    ModuleIdentifier identifier = ModuleIdentifier.fromString((String)moduleSpec);
                    return loader.loadModule(identifier).getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ModuleLoadException((Throwable)pae);
        }
    }

    static SecurityContext getSecurityContext() {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    static Principal getPrincipal() {
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                Principal principal = null;
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    principal = sc.getUtil().getUserPrincipal();
                }
                return principal;
            }
        });
    }

    static Object getCredential() {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Object credential = null;
                SecurityContext sc = SecurityActions.getSecurityContext();
                if (sc != null) {
                    credential = sc.getUtil().getCredential();
                }
                return credential;
            }
        });
    }
}

