/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.security;

/**
 * Attributes used by the security subsystem.
 *
 * @author <a href="mailto:darran.lofthouse@jboss.com">Darran Lofthouse</a>
 */
public interface CommonAttributes {

    String AUDIT_MANAGER_CLASS_NAME = "audit-manager-class-name";
    String AUTHENTICATION_MANAGER_CLASS_NAME = "authentication-manager-class-name";
    String AUTHORIZATION_MANAGER_CLASS_NAME = "authorization-manager-class-name";
    String DEEP_COPY_SUBJECT_MODE = "deep-copy-subject-mode";
    String DEFAULT_CALLBACK_HANDLER_CLASS_NAME = "default-callback-handler-class-name";
    String IDENTITY_TRUST_MANAGER_CLASS_NAME = "identity-trust-manager-class-name";
    String MAPPING_MANAGER_CLASS_NAME = "mapping-manager-class-name";
    String MODULE_OPTIONS = "module-options";
    String SECURITY_MANAGEMENT = "security-management";
    String SECURITY_DOMAIN = "security-domain";
    String SUBJECT_FACTORY = "subject-factory";
    String SUBJECT_FACTORY_CLASS_NAME = "subject-factory-class-name";
}
