/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(final String moduleSpec) throws ModuleLoadException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<ModuleClassLoader>(){

                @Override
                public ModuleClassLoader run() throws ModuleLoadException {
                    ModuleLoader loader = Module.getCallerModuleLoader();
                    ModuleIdentifier identifier = ModuleIdentifier.fromString((String)moduleSpec);
                    return loader.loadModule(identifier).getClassLoader();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new ModuleLoadException((Throwable)pae);
        }
    }

    static void setSecurityProperty(final String key, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Security.setProperty(key, value);
                return null;
            }
        });
    }
}

