/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.security.service.ThreadLocalStack;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.callbacks.SecurityContextCallbackHandler;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.plugins.SimpleIdentity;

public class SimpleSecurityManager {
    private ThreadLocalStack<SecurityContext> contexts = new ThreadLocalStack();

    private static PrivilegedAction<SecurityContext> securityContext() {
        return new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        };
    }

    private static SecurityContext establishSecurityContext(String securityDomain) {
        try {
            SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
            SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
            return securityContext;
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public Principal getCallerPrincipal() {
        SecurityContext securityContext = AccessController.doPrivileged(SimpleSecurityManager.securityContext());
        if (securityContext == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        Object principal = securityContext.getIncomingRunAs();
        if (principal == null) {
            principal = this.getPrincipal(securityContext.getSubjectInfo().getAuthenticatedSubject());
        }
        if (principal == null) {
            return this.getUnauthenticatedIdentity().asPrincipal();
        }
        return principal;
    }

    private Principal getPrincipal(Subject subject) {
        Set<Principal> principals;
        Principal principal = null;
        Principal callerPrincipal = null;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                Enumeration e;
                Group g;
                if (!(p instanceof Group) && principal == null) {
                    principal = p;
                }
                if (!(p instanceof Group) || !(g = (Group)Group.class.cast(p)).getName().equals("CallerPrincipal") || callerPrincipal != null || !(e = g.members()).hasMoreElements()) continue;
                callerPrincipal = (Principal)e.nextElement();
            }
        }
        return callerPrincipal == null ? principal : callerPrincipal;
    }

    public boolean isCallerInRole(SecurityRolesMetaData mappedRoles, String ... roleNames) {
        boolean userNotInRole;
        Principal callerPrincipal;
        Set mapped;
        SecurityContext securityContext = AccessController.doPrivileged(SimpleSecurityManager.securityContext());
        if (securityContext == null) {
            return false;
        }
        RoleGroup roleGroup = null;
        RunAs runAs = securityContext.getIncomingRunAs();
        if (runAs != null && runAs instanceof RunAsIdentity) {
            RunAsIdentity runAsIdentity = (RunAsIdentity)runAs;
            roleGroup = runAsIdentity.getRunAsRolesAsRoleGroup();
        } else {
            AuthorizationManager am = securityContext.getAuthorizationManager();
            SecurityContextCallbackHandler scb = new SecurityContextCallbackHandler(securityContext);
            roleGroup = am.getSubjectRoles(securityContext.getSubjectInfo().getAuthenticatedSubject(), (CallbackHandler)scb);
        }
        List roles = roleGroup.getRoles();
        HashSet<String> requiredRoles = new HashSet<String>();
        for (String current : roleNames) {
            requiredRoles.add(current);
        }
        HashSet<String> actualRoles = new HashSet<String>();
        for (Role current : roles) {
            actualRoles.add(current.getRoleName());
        }
        if (mappedRoles != null && (mapped = mappedRoles.getSecurityRoleNamesByPrincipal((callerPrincipal = this.getCallerPrincipal()).getName())) != null) {
            actualRoles.addAll(mapped);
        }
        return !(userNotInRole = Collections.disjoint(requiredRoles, actualRoles));
    }

    public void push(String securityDomain, String runAs, String runAsPrincipal, Set<String> extraRoles) {
        boolean authenticated;
        RunAs currentRunAs;
        boolean trusted;
        SecurityContext previous = SecurityContextAssociation.getSecurityContext();
        this.contexts.push(previous);
        SecurityContext current = SimpleSecurityManager.establishSecurityContext(securityDomain);
        if (previous != null) {
            current.setSubjectInfo(previous.getSubjectInfo());
            current.setIncomingRunAs(previous.getOutgoingRunAs());
        }
        boolean bl = trusted = (currentRunAs = current.getIncomingRunAs()) != null && currentRunAs instanceof RunAsIdentity;
        if (!trusted && !(authenticated = this.authenticate(current))) {
            throw new SecurityException("Invalid User");
        }
        if (runAs != null) {
            RunAsIdentity runAsIdentity = new RunAsIdentity(runAs, runAsPrincipal, extraRoles);
            current.setOutgoingRunAs((RunAs)runAsIdentity);
        } else if (previous != null && previous.getOutgoingRunAs() != null) {
            current.setOutgoingRunAs(previous.getOutgoingRunAs());
        }
    }

    private boolean authenticate(SecurityContext context) {
        SecurityContextUtil util = context.getUtil();
        SubjectInfo subjectInfo = context.getSubjectInfo();
        Subject subject = new Subject();
        Principal principal = util.getUserPrincipal();
        Object credential = util.getCredential();
        boolean authenticated = false;
        if (principal == null) {
            Identity unauthenticatedIdentity = this.getUnauthenticatedIdentity();
            subjectInfo.addIdentity(unauthenticatedIdentity);
            subject.getPrincipals().add(unauthenticatedIdentity.asPrincipal());
            authenticated = true;
        }
        if (!authenticated) {
            AuthenticationManager authenticationManager = context.getAuthenticationManager();
            authenticated = authenticationManager.isValid(principal, credential, subject);
        }
        if (authenticated) {
            subjectInfo.setAuthenticatedSubject(subject);
        }
        return authenticated;
    }

    private Identity getUnauthenticatedIdentity() {
        return new SimpleIdentity("anonymous");
    }

    public void pop() {
        SecurityContext sc = this.contexts.pop();
        SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
    }
}

