/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class KeyStoreAttributeDefinition
extends AttributeDefinition {
    private static final ParameterValidator keyStoreValidator;
    private static final ParameterValidator fieldValidator;

    protected KeyStoreAttributeDefinition(String name) {
        super(name, null, null, ModelType.OBJECT, true, false, null, keyStoreValidator, null, null, new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES});
    }

    public void marshallAsAttribute(ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
        if (this.isMarshallable(resourceModel, marshallDefault)) {
            if ((resourceModel = resourceModel.get(this.getName())).hasDefined("password")) {
                writer.writeAttribute(this.getName() + "-" + "password", resourceModel.get("password").asString());
            }
            if (resourceModel.hasDefined("type")) {
                writer.writeAttribute(this.getName() + "-" + "type", resourceModel.get("type").asString());
            }
            if (resourceModel.hasDefined("url")) {
                writer.writeAttribute(this.getName() + "-" + "url", resourceModel.get("url").asString());
            }
            if (resourceModel.hasDefined("provider")) {
                writer.writeAttribute(this.getName() + "-" + "provider", resourceModel.get("provider").asString());
            }
            if (resourceModel.hasDefined("provider-argument")) {
                writer.writeAttribute(this.getName() + "-" + "provider-argument", resourceModel.get("provider-argument").asString());
            }
        }
    }

    public static ModelNode parseField(String name, String value, Location location) throws XMLStreamException {
        String trimmed = value == null ? null : value.trim();
        ModelNode node = trimmed != null ? new ModelNode().set(trimmed) : new ModelNode();
        try {
            fieldValidator.validateParameter(name, node);
        }
        catch (OperationFailedException e) {
            throw new XMLStreamException(e.getFailureDescription().toString(), location);
        }
        return node;
    }

    public ModelNode addResourceAttributeDescription(ModelNode resourceDescription, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addResourceAttributeDescription(resourceDescription, resolver, locale, bundle2);
        this.addAttributeValueTypeDescription(result, resolver, locale, bundle2);
        return result;
    }

    public ModelNode addOperationParameterDescription(ModelNode resourceDescription, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode result = super.addOperationParameterDescription(resourceDescription, operationName, resolver, locale, bundle2);
        this.addOperationParameterValueTypeDescription(result, operationName, resolver, locale, bundle2);
        return result;
    }

    private void addAttributeValueTypeDescription(ModelNode result, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(result);
        valueType.get(new String[]{"password", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"password"}));
        valueType.get(new String[]{"type", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"type"}));
        valueType.get(new String[]{"url", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"url"}));
        valueType.get(new String[]{"provider", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"provider"}));
        valueType.get(new String[]{"provider-argument", "description"}).set(resolver.getResourceAttributeValueTypeDescription(this.getName(), locale, bundle2, new String[]{"provider-argument"}));
    }

    private void addOperationParameterValueTypeDescription(ModelNode result, String operationName, ResourceDescriptionResolver resolver, Locale locale, ResourceBundle bundle2) {
        ModelNode valueType = this.getNoTextValueTypeDescription(result);
        valueType.get(new String[]{"password", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"password"}));
        valueType.get(new String[]{"type", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"type"}));
        valueType.get(new String[]{"url", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"url"}));
        valueType.get(new String[]{"provider", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"provider"}));
        valueType.get(new String[]{"provider-argument", "description"}).set(resolver.getOperationParameterValueTypeDescription(operationName, this.getName(), locale, bundle2, new String[]{"provider-argument"}));
    }

    private ModelNode getNoTextValueTypeDescription(ModelNode parent) {
        ModelNode valueType = parent.get("value-type");
        ModelNode password = valueType.get("password");
        password.get("description");
        password.get("type").set(ModelType.STRING);
        password.get("nillable").set(true);
        ModelNode type = valueType.get("type");
        type.get("description");
        type.get("type").set(ModelType.STRING);
        type.get("nillable").set(true);
        ModelNode url = valueType.get("url");
        url.get("description");
        url.get("type").set(ModelType.STRING);
        url.get("nillable").set(true);
        ModelNode provider = valueType.get("provider");
        provider.get("description");
        provider.get("type").set(ModelType.STRING);
        provider.get("nillable").set(true);
        ModelNode argument = valueType.get("provider-argument");
        argument.get("description");
        argument.get("type").set(ModelType.STRING);
        argument.get("nillable").set(true);
        return valueType;
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        throw new UnsupportedOperationException("Use the ResourceDescriptionResolver variant");
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        throw new UnsupportedOperationException("Use the ResourceDescriptionResolver variant");
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    static {
        ParametersValidator delegate = new ParametersValidator();
        delegate.registerValidator("password", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        delegate.registerValidator("type", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        delegate.registerValidator("url", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, false));
        delegate.registerValidator("provider", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        delegate.registerValidator("provider-argument", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        keyStoreValidator = new ParametersOfValidator(delegate);
        fieldValidator = delegate;
    }
}

