/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.service;

import java.lang.reflect.Constructor;
import java.security.Policy;
import java.util.Properties;
import java.util.Set;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextHandler;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.service.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.security.auth.callback.CallbackHandlerPolicyContextHandler;
import org.jboss.security.jacc.SubjectPolicyContextHandler;
import org.picketbox.Version;

public class SecurityBootstrapService
implements Service<Void> {
    public static final ServiceName SERVICE_NAME = SecurityExtension.JBOSS_SECURITY.append(new String[]{"bootstrap"});
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.security");
    protected volatile Properties securityProperty;
    private Policy oldPolicy;
    private Policy jaccPolicy;
    private static final String JACC_POLICY_PROVIDER = "javax.security.jacc.policy.provider";

    public void start(StartContext context) throws StartException {
        log.debugf("Starting SecurityBootstrapService", new Object[0]);
        try {
            log.info((Object)("Picketbox version=" + Version.VERSION));
            this.oldPolicy = Policy.getPolicy();
            String provider = SecurityActions.getSystemProperty(JACC_POLICY_PROVIDER, "org.jboss.security.jacc.DelegatingPolicy");
            Class<?> providerClass = SecurityActions.loadClass(provider);
            try {
                Class[] ctorSig = new Class[]{Policy.class};
                Constructor<?> ctor = providerClass.getConstructor(ctorSig);
                Object[] ctorArgs = new Object[]{this.oldPolicy};
                this.jaccPolicy = (Policy)ctor.newInstance(ctorArgs);
            }
            catch (NoSuchMethodException e) {
                log.debugf("Provider does not support ctor(Policy)", new Object[0]);
                try {
                    this.jaccPolicy = (Policy)providerClass.newInstance();
                }
                catch (Exception e1) {
                    throw new StartException((Throwable)e1);
                }
            }
            catch (Exception e) {
                throw new StartException((Throwable)e);
            }
            Policy.setPolicy(this.jaccPolicy);
            this.jaccPolicy.refresh();
            SubjectPolicyContextHandler handler = new SubjectPolicyContextHandler();
            PolicyContext.registerHandler((String)"javax.security.auth.Subject.container", (PolicyContextHandler)handler, (boolean)true);
            CallbackHandlerPolicyContextHandler chandler = new CallbackHandlerPolicyContextHandler();
            PolicyContext.registerHandler((String)"org.jboss.security.auth.spi.CallbackHandler", (PolicyContextHandler)chandler, (boolean)true);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        Set handlerKeys = PolicyContext.getHandlerKeys();
        handlerKeys.remove("org.jboss.security.auth.spi.CallbackHandler");
        handlerKeys.remove("javax.security.auth.Subject.container");
        if (this.jaccPolicy != null) {
            Policy.setPolicy(this.oldPolicy);
        }
    }

    public Void getValue() throws IllegalStateException {
        return null;
    }
}

