/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.deployment;

import javax.security.jacc.PolicyConfiguration;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.security.deployment.EarSecurityDeployer;
import org.jboss.as.security.service.JaccService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class JaccEarDeploymentProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        JaccService service;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EarSecurityDeployer deployer = null;
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)deploymentUnit) && (service = (deployer = new EarSecurityDeployer()).deploy(deploymentUnit)) != null) {
            ServiceName jaccServiceName = JaccService.SERVICE_NAME.append(new String[]{deploymentUnit.getName()});
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceBuilder builder = serviceTarget.addService(jaccServiceName, service);
            if (deploymentUnit.getParent() != null) {
                DeploymentUnit parentDU = deploymentUnit.getParent();
                builder.addDependency(JaccService.SERVICE_NAME.append(new String[]{parentDU.getName()}), PolicyConfiguration.class, service.getParentPolicyInjector());
            }
            builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
    }

    public void undeploy(DeploymentUnit context) {
        EarSecurityDeployer deployer = null;
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)context)) {
            deployer = new EarSecurityDeployer();
            deployer.undeploy(context);
        }
    }
}

