/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.security.SecurityDomainAdd;
import org.jboss.as.security.service.SecurityDomainService;
import org.jboss.dmr.ModelNode;

class SecurityDomainRemove
extends AbstractRemoveStepHandler {
    static final String OPERATION_NAME = "remove";
    static final SecurityDomainRemove INSTANCE = new SecurityDomainRemove();

    private SecurityDomainRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String securityDomain = address.getLastElement().getValue();
        context.removeService(SecurityDomainService.SERVICE_NAME.append(new String[]{securityDomain}));
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String securityDomain = address.getLastElement().getValue();
        String cacheType = SecurityDomainAdd.getAuthenticationCacheType(operation);
        SecurityDomainAdd.INSTANCE.launchServices(context, securityDomain, model);
    }
}

