/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.server.ApplicationServerService;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerMessages;
import org.jboss.as.server.Services;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.AsyncFuture;
import org.jboss.threads.AsyncFutureTask;
import org.jboss.threads.JBossExecutors;

final class BootstrapImpl
implements Bootstrap {
    private static final int MAX_THREADS = ServerEnvironment.getBootstrapMaxThreads();
    private final ServiceContainer container = ServiceContainer.Factory.create((String)"jboss-as", (int)MAX_THREADS, (long)30L, (TimeUnit)TimeUnit.SECONDS);

    BootstrapImpl() {
    }

    @Override
    public AsyncFuture<ServiceContainer> bootstrap(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        assert (configuration != null) : "configuration is null";
        ModuleLoader moduleLoader = configuration.getModuleLoader();
        Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = configuration.getConfigurationPersisterFactory();
        assert (configurationPersisterFactory != null) : "configurationPersisterFactory is null";
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)moduleLoader.loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
        }
        catch (ModuleLoadException e) {
            throw ServerMessages.MESSAGES.vfsNotAvailable();
        }
        final FutureServiceContainer future = new FutureServiceContainer(this.container);
        ServiceTarget tracker = this.container.subTarget();
        ControlledProcessState processState = new ControlledProcessState(configuration.getServerEnvironment().isStandalone());
        ControlledProcessStateService.addService((ServiceTarget)tracker, (ControlledProcessState)processState);
        ApplicationServerService applicationServerService = new ApplicationServerService(extraServices, configuration, processState);
        tracker.addService(Services.JBOSS_AS, (Service)applicationServerService).install();
        ServiceController rootService = this.container.getRequiredService(Services.JBOSS_AS);
        rootService.addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        controller.removeListener((ServiceListener)this);
                        ServiceController controllerServiceController = controller.getServiceContainer().getRequiredService(Services.JBOSS_SERVER_CONTROLLER);
                        controllerServiceController.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                                switch (transition) {
                                    case STARTING_to_UP: {
                                        future.done();
                                        controller.removeListener((ServiceListener)this);
                                        break;
                                    }
                                    case STARTING_to_START_FAILED: {
                                        future.failed((Throwable)controller.getStartException());
                                        controller.removeListener((ServiceListener)this);
                                        break;
                                    }
                                    case REMOVING_to_REMOVED: {
                                        future.failed((Throwable)ServerMessages.MESSAGES.serverControllerServiceRemoved());
                                        controller.removeListener((ServiceListener)this);
                                    }
                                }
                            }
                        });
                        break;
                    }
                    case STARTING_to_START_FAILED: {
                        controller.removeListener((ServiceListener)this);
                        future.failed((Throwable)controller.getStartException());
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        controller.removeListener((ServiceListener)this);
                        future.failed(ServerMessages.MESSAGES.rootServiceRemoved());
                    }
                }
            }
        });
        return future;
    }

    @Override
    public AsyncFuture<ServiceContainer> startup(Bootstrap.Configuration configuration, List<ServiceActivator> extraServices) {
        try {
            ServiceContainer container = (ServiceContainer)this.bootstrap(configuration, extraServices).get();
            ServiceController controller = container.getRequiredService(Services.JBOSS_AS);
            return (AsyncFuture)controller.getValue();
        }
        catch (Exception ex) {
            throw ServerMessages.MESSAGES.cannotStartServer(ex);
        }
    }

    static class FutureServiceContainer
    extends AsyncFutureTask<ServiceContainer> {
        private final ServiceContainer container;

        FutureServiceContainer(ServiceContainer container) {
            super((Executor)JBossExecutors.directExecutor());
            this.container = container;
        }

        public void asyncCancel(boolean interruptionDesired) {
            this.container.shutdown();
            this.container.addTerminateListener(new ServiceContainer.TerminateListener(){

                public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                    FutureServiceContainer.this.setCancelled();
                }
            });
        }

        void done() {
            this.setResult(this.container);
        }

        void failed(Throwable t) {
            this.setFailed(t);
        }
    }
}

