/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class JMSAdminOperations {
    private final ModelControllerClient modelControllerClient;
    private static final Logger logger = Logger.getLogger(JMSAdminOperations.class);

    public JMSAdminOperations() {
        this("localhost", 9999);
    }

    public JMSAdminOperations(String hostName, int port) {
        try {
            this.modelControllerClient = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(hostName), (int)port, (CallbackHandler)Authentication.getCallbackHandler());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Cannot create model controller client for host: " + hostName + " and port " + port, e);
        }
    }

    public void close() {
        try {
            this.modelControllerClient.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient;
    }

    public void createJmsQueue(String queueName, String jndiName) {
        this.createJmsDestination("jms-queue", queueName, jndiName);
    }

    public void createJmsTopic(String topicName, String jndiName) {
        this.createJmsDestination("jms-topic", topicName, jndiName);
    }

    private void createJmsDestination(String destinationType, String destinationName, String jndiName) {
        ModelNode createJmsQueueOperation = new ModelNode();
        createJmsQueueOperation.get("operation").set("add");
        createJmsQueueOperation.get("address").add("subsystem", "messaging");
        createJmsQueueOperation.get("address").add("hornetq-server", "default");
        createJmsQueueOperation.get("address").add(destinationType, destinationName);
        createJmsQueueOperation.get("entries").add(jndiName);
        try {
            this.applyUpdate(createJmsQueueOperation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeJmsQueue(String queueName) {
        this.removeJmsDestination("jms-queue", queueName);
    }

    public void removeJmsTopic(String topicName) {
        this.removeJmsDestination("jms-topic", topicName);
    }

    private void removeJmsDestination(String destinationType, String destinationName) {
        ModelNode removeJmsQueue = new ModelNode();
        removeJmsQueue.get("operation").set("remove");
        removeJmsQueue.get("address").add("subsystem", "messaging");
        removeJmsQueue.get("address").add("hornetq-server", "default");
        removeJmsQueue.get("address").add(destinationType, destinationName);
        try {
            this.applyUpdate(removeJmsQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void applyUpdate(ModelNode update) throws IOException, JMSAdminOperationException {
        ModelNode result = this.modelControllerClient.execute(update);
        if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
            logger.info((Object)("Operation successful for update = " + update.toString()));
            return;
        }
        if (result.hasDefined("failure-description")) {
            String failureDesc = result.get("failure-description").toString();
            throw new JMSAdminOperationException(failureDesc);
        }
        throw new JMSAdminOperationException("Operation not successful; outcome = " + result.get("outcome"));
    }

    private class JMSAdminOperationException
    extends Exception {
        JMSAdminOperationException(String msg, Throwable cause) {
            super(msg, cause);
        }

        JMSAdminOperationException(String msg) {
            super(msg);
        }
    }
}

