/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.base;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.as.test.integration.management.util.SimpleServlet;
import org.jboss.as.test.shared.staxmapper.XMLExtendedStreamWriterFactory;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ZipExporterImpl;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.jboss.staxmapper.XMLMapper;
import org.junit.Assert;

public class AbstractMgmtTestBase {
    protected static final int MGMT_PORT = 9999;
    protected static final String tempDir = System.getProperty("java.io.tmpdir");
    private static ModelControllerClient modelControllerClient;
    private static File brokenWar;

    protected static void initModelControllerClient(String hostName, int port) {
        if (modelControllerClient == null) {
            try {
                modelControllerClient = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(hostName), (int)port, (CallbackHandler)Authentication.getCallbackHandler());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot create model controller client for host: " + hostName + " and port " + port, e);
            }
        }
    }

    protected ModelControllerClient getModelControllerClient() {
        return modelControllerClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void closeModelControllerClient() throws IOException {
        if (modelControllerClient != null) {
            try {
                modelControllerClient.close();
            }
            finally {
                modelControllerClient = null;
            }
        }
    }

    protected static ModelNode executeOperation(ModelNode op, boolean unwrapResult) throws IOException, MgmtOperationException {
        ModelNode ret = modelControllerClient.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new MgmtOperationException("Management operation failed: " + ret.get("failure-description"), op, ret);
        }
        return ret.get("result");
    }

    protected static ModelNode executeOperation(ModelNode op) throws IOException, MgmtOperationException {
        return AbstractMgmtTestBase.executeOperation(op, true);
    }

    protected static ModelNode executeOperation(String address, String operation) throws IOException, MgmtOperationException {
        return AbstractMgmtTestBase.executeOperation(ModelUtil.createOpNode(address, operation));
    }

    protected ModelNode executeAndRollbackOperation(ModelNode op) throws IOException, OperationFormatException {
        ModelNode addDeploymentOp = ModelUtil.createOpNode("deployment=malformedDeployment.war", "add");
        addDeploymentOp.get("content").get(0).get("input-stream-index").set(0);
        ModelNode deploymentOp = new ModelNode();
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.setOperationName("deploy");
        builder.addNode("deployment", "malformedDeployment.war");
        ModelNode[] steps = new ModelNode[]{op, addDeploymentOp, builder.buildRequest()};
        ModelNode compositeOp = ModelUtil.createCompositeNode(steps);
        OperationBuilder ob = new OperationBuilder(compositeOp, true);
        ob.addInputStream((InputStream)new FileInputStream(AbstractMgmtTestBase.getBrokenWar()));
        return modelControllerClient.execute(ob.build());
    }

    protected static void remove(ModelNode address) throws IOException, MgmtOperationException {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("remove");
        operation.get("address").set(address);
        AbstractMgmtTestBase.executeOperation(operation);
    }

    private static File getBrokenWar() {
        if (brokenWar != null) {
            return brokenWar;
        }
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"deployment2.war");
        war.addClass(SimpleServlet.class);
        war.addAsWebInfResource((Asset)new StringAsset("Malformed"), "web.xml");
        brokenWar = new File(System.getProperty("java.io.tmpdir") + File.separator + "malformedDeployment.war");
        brokenWar.deleteOnExit();
        new ZipExporterImpl((Archive)war).exportTo(brokenWar, true);
        return brokenWar;
    }

    protected Map<String, ModelNode> getChildren(ModelNode result) {
        assert (result.isDefined());
        HashMap<String, ModelNode> steps = new HashMap<String, ModelNode>();
        for (Property property : result.asPropertyList()) {
            steps.put(property.getName(), property.getValue());
        }
        return steps;
    }

    protected ModelNode findNodeWithProperty(List<ModelNode> newList, String propertyName, String setTo) {
        ModelNode toReturn = null;
        for (ModelNode result : newList) {
            Map<String, ModelNode> parseChildren = this.getChildren(result);
            if (parseChildren.isEmpty() || parseChildren.get(propertyName) == null || !parseChildren.get(propertyName).asString().equals(setTo)) continue;
            toReturn = result;
            break;
        }
        return toReturn;
    }

    public static String ModelToXml(String subsystemName, String childType, XMLElementWriter<SubsystemMarshallingContext> parser) throws Exception {
        ModelNode address = new ModelNode();
        address.add("subsystem", subsystemName);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-children-resources");
        operation.get("child-type").set(childType);
        operation.get("recursive").set(true);
        operation.get("address").set(address);
        ModelNode result = AbstractMgmtTestBase.executeOperation(operation);
        Assert.assertNotNull((Object)result);
        ModelNode dsNode = new ModelNode();
        dsNode.get(childType).set(result);
        StringWriter strWriter = new StringWriter();
        XMLExtendedStreamWriter writer = XMLExtendedStreamWriterFactory.create(XMLOutputFactory.newFactory().createXMLStreamWriter(strWriter));
        parser.writeContent(writer, (Object)new SubsystemMarshallingContext(dsNode, writer));
        writer.flush();
        return strWriter.toString();
    }

    public static List<ModelNode> XmlToModelOperations(String xml, String nameSpaceUriString, XMLElementReader<List<ModelNode>> parser) throws Exception {
        XMLMapper mapper = XMLMapper.Factory.create();
        mapper.registerRootElement(new QName(nameSpaceUriString, "subsystem"), parser);
        StringReader strReader = new StringReader(xml);
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new StreamSource(strReader));
        ArrayList<ModelNode> newList = new ArrayList<ModelNode>();
        mapper.parseDocument(newList, reader);
        return newList;
    }

    public static ModelNode operationListToCompositeOperation(List<ModelNode> operations) {
        return AbstractMgmtTestBase.operationListToCompositeOperation(operations, true);
    }

    public static ModelNode operationListToCompositeOperation(List<ModelNode> operations, boolean skipFirst) {
        if (skipFirst) {
            operations.remove(0);
        }
        ModelNode[] steps = new ModelNode[operations.size()];
        operations.toArray(steps);
        return ModelUtil.createCompositeNode(steps);
    }

    public static String readXmlResource(String name) throws IOException {
        String line;
        File f = new File(name);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        StringWriter writer = new StringWriter();
        while ((line = reader.readLine()) != null) {
            writer.write(line);
        }
        return writer.toString();
    }

    static {
        brokenWar = null;
    }
}

