/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.util.Enumeration;
import java.util.Properties;
import org.jboss.dmr.ModelNode;

public class ComplexPropertiesParseUtils {
    public static Properties commonDsProperties(String jndiName) {
        Properties params = new Properties();
        params.put("use-java-context", "true");
        params.put("spy", "false");
        params.put("use-ccm", "true");
        params.put("jndi-name", jndiName);
        params.put("driver-name", "h2");
        params.put("new-connection-sql", "select 1");
        params.put("transaction-isolation", "TRANSACTION_READ_COMMITTED");
        params.put("url-delimiter", ":");
        params.put("url-selector-strategy-class-name", "someClass");
        params.put("min-pool-size", "1");
        params.put("max-pool-size", "5");
        params.put("pool-prefill", "true");
        params.put("pool-use-strict-min", "true");
        params.put("flush-strategy", "EntirePool");
        params.put("user-name", "sa");
        params.put("password", "sa");
        params.put("security-domain", "HsqlDbRealm");
        params.put("reauth-plugin-class-name", "someClass1");
        params.put("valid-connection-checker-class-name", "someClass2");
        params.put("check-valid-connection-sql", "select 1");
        params.put("validate-on-match", "true");
        params.put("background-validation", "true");
        params.put("background-validation-millis", "2000");
        params.put("use-fast-fail", "true");
        params.put("stale-connection-checker-class-name", "someClass3");
        params.put("exception-sorter-class-name", "someClass4");
        params.put("blocking-timeout-wait-millis", "20000");
        params.put("idle-timeout-minutes", "4");
        params.put("set-tx-query-timeout", "true");
        params.put("query-timeout", "120");
        params.put("use-try-lock", "100");
        params.put("allocation-retry", "2");
        params.put("allocation-retry-wait-millis", "3000");
        params.put("track-statements", "nowarn");
        params.put("prepared-statements-cache-size", "30");
        params.put("share-prepared-statements", "true");
        return params;
    }

    public static Properties xaDsProperties(String jndiName) {
        Properties params = ComplexPropertiesParseUtils.commonDsProperties(jndiName);
        params.put("xa-datasource-class", "org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource");
        params.put("same-rm-override", "true");
        params.put("interleaving", "true");
        params.put("no-tx-separate-pool", "true");
        params.put("pad-xid", "true");
        params.put("wrap-xa-resource", "true");
        params.put("xa-resource-timeout", "120");
        params.put("no-recovery", "false");
        params.put("recovery-plugin-class-name", "someClass5");
        params.put("recovery-username", "sa");
        params.put("recovery-password", "sa");
        params.put("recovery-security-domain", "HsqlDbRealm");
        return params;
    }

    public static Properties nonXaDsProperties(String jndiName) {
        Properties params = ComplexPropertiesParseUtils.commonDsProperties(jndiName);
        params.put("jta", "false");
        params.put("driver-class", "org.hsqldb.jdbcDriver");
        params.put("datasource-class", "org.jboss.as.connector.subsystems.datasources.ModifiableDataSource");
        params.put("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        return params;
    }

    public static Properties raCommonProperties() {
        Properties params = new Properties();
        params.put("archive", "some.rar");
        params.put("transaction-support", "XATransaction");
        params.put("bootstrap-context", "someContext");
        return params;
    }

    public static Properties raConnectionProperties() {
        Properties params = new Properties();
        params.put("use-java-context", "false");
        params.put("class-name", "Class1");
        params.put("use-ccm", "true");
        params.put("jndi-name", "java:jboss/name1");
        params.put("enabled", "false");
        params.put("min-pool-size", "1");
        params.put("max-pool-size", "5");
        params.put("pool-prefill", "true");
        params.put("pool-use-strict-min", "true");
        params.put("flush-strategy", "IdleConnections");
        params.put("same-rm-override", "true");
        params.put("interleaving", "true");
        params.put("no-tx-separate-pool", "true");
        params.put("pad-xid", "true");
        params.put("wrap-xa-resource", "true");
        params.put("application", "true");
        params.put("security-domain-and-application", "HsqlDbRealm1");
        params.put("security-domain", "HsqlDbRealm");
        params.put("background-validation", "true");
        params.put("background-validation-millis", "5000");
        params.put("use-fast-fail", "true");
        params.put("blocking-timeout-wait-millis", "5000");
        params.put("idle-timeout-minutes", "4");
        params.put("allocation-retry", "2");
        params.put("allocation-retry-wait-millis", "3000");
        params.put("xa-resource-timeout", "300");
        params.put("no-recovery", "false");
        params.put("recovery-plugin-class-name", "someClass2");
        params.put("recovery-username", "sa");
        params.put("recovery-password", "sa-pass");
        params.put("recovery-security-domain", "HsqlDbRealm");
        return params;
    }

    public static Properties raAdminProperties() {
        Properties params = new Properties();
        params.put("use-java-context", "false");
        params.put("class-name", "Class3");
        params.put("jndi-name", "java:jboss/Name3");
        params.put("enabled", "true");
        return params;
    }

    public static void setOperationParams(ModelNode operation, Properties params) {
        Enumeration<?> e = params.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            operation.get(str).set(params.getProperty(str));
        }
    }

    public static void addExtensionProperties(ModelNode operation) {
        operation.get(new String[]{"reauth-plugin-properties", "name"}).set("Property1");
        operation.get(new String[]{"valid-connection-checker-properties", "name"}).set("Property2");
        operation.get(new String[]{"stale-connection-checker-properties", "name"}).set("Property3");
        operation.get(new String[]{"exception-sorter-properties", "name"}).set("Property4");
    }

    public static boolean checkModelParams(ModelNode node, Properties params) {
        if (node == null) {
            return false;
        }
        Enumeration<?> e = params.propertyNames();
        while (e.hasMoreElements()) {
            String str = (String)e.nextElement();
            String par = params.getProperty(str);
            if (node.get(str) == null) {
                return false;
            }
            if (node.get(str).asString().equals(par)) continue;
            return false;
        }
        return true;
    }
}

