/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.jca;

import java.util.List;
import org.jboss.as.connector.subsystems.datasources.DataSourcesExtension;
import org.jboss.as.connector.subsystems.datasources.Namespace;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.test.integration.management.base.ArquillianResourceMgmtTestBase;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class DsMgmtTestBase
extends ArquillianResourceMgmtTestBase {
    public static ModelNode baseAddress;

    public static void setBaseAddress(String dsType, String dsName) {
        baseAddress = new ModelNode();
        baseAddress.add("subsystem", "datasources");
        baseAddress.add(dsType, dsName);
        baseAddress.protect();
    }

    protected void removeDs() throws Exception {
        this.remove(baseAddress);
    }

    protected void setModel(String filename) throws Exception {
        String xml = DsMgmtTestBase.readXmlResource(System.getProperty("jbossas.ts.integ.dir") + "/basic/src/test/resources/jca/metrics/data-sources/" + filename);
        List<ModelNode> operations = DsMgmtTestBase.xmlToModelOperations(xml, Namespace.CURRENT.getUriString(), (XMLElementReader<List<ModelNode>>)new DataSourcesExtension.DataSourceSubsystemParser());
        this.executeOperation(DsMgmtTestBase.operationListToCompositeOperation(operations));
    }

    protected void setBadModel(String filename) throws Exception {
        this.setModel(filename);
        this.takeSnapShot();
        this.removeDs();
    }

    protected ModelNode readAttribute(ModelNode address, String attribute) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-attribute");
        operation.get("name").set(attribute);
        operation.get("address").set(address);
        return this.executeOperation(operation);
    }

    protected List<ModelNode> marshalAndReparseDsResources(String childType) throws Exception {
        DataSourcesExtension.DataSourceSubsystemParser parser = new DataSourcesExtension.DataSourceSubsystemParser();
        return DsMgmtTestBase.xmlToModelOperations(this.modelToXml("datasources", childType, (XMLElementWriter<SubsystemMarshallingContext>)parser), Namespace.CURRENT.getUriString(), (XMLElementReader<List<ModelNode>>)parser);
    }

    private void testCon(String dsName, String type) throws Exception {
        ModelNode address = new ModelNode();
        address.add("subsystem", "datasources");
        address.add(type, dsName);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("test-connection-in-pool");
        operation.get("address").set(address);
        this.executeOperation(operation);
    }

    protected void testConnection(String dsName) throws Exception {
        this.testCon(dsName, "data-source");
    }

    protected void testConnectionXA(String dsName) throws Exception {
        this.testCon(dsName, "xa-data-source");
    }
}

