/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.classloader.leak;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import junit.framework.Assert;
import org.jboss.as.test.classloader.leak.ClassLoaderRef;
import org.jboss.as.test.classloader.leak.ClassLoaderServlet;
import org.jboss.as.test.classloader.leak.ejb.ClusteredStatefulBean;
import org.jboss.as.test.classloader.leak.ejb.ClusteredStatelessBean;
import org.jboss.as.test.classloader.leak.ejb.EntityBean;
import org.jboss.as.test.classloader.leak.ejb.StatefulBean;
import org.jboss.as.test.classloader.leak.ejb.StatefulRemote;
import org.jboss.as.test.classloader.leak.ejb.StatelessBean;
import org.jboss.as.test.classloader.leak.ejb.StatelessRemote;
import org.jboss.as.test.integration.common.HttpRequest;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;

public class AbstractClassloaderLeakTestBase {
    private static final Logger log = Logger.getLogger(AbstractClassloaderLeakTestBase.class);
    public static final String DEPLOYMENT_DRIVER_ID = "deployment_drv";
    public static final String DEPLOYMENT_DRIVER_NAME = "ClassloaderLeakTestCase.war";
    public static final String DEPLOYMENT_APP_ID = "deployment_app";
    protected static final String NL = System.getProperty("line.separator");
    protected static final String webURI = "http://" + TestSuiteEnvironment.getServerAddress() + ":8080";
    private static final String PERSISTENCE_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <persistence xmlns=\"http://java.sun.com/xml/ns/persistence\" version=\"1.0\">  <persistence-unit name=\"test-unit\">    <description>Persistence Unit.    </description>  <jta-data-source>java:jboss/datasources/ExampleDS</jta-data-source><properties> <property name=\"hibernate.hbm2ddl.auto\" value=\"create-drop\"/><property name=\"jboss.entity.manager.factory.jndi.name\" value=\"testEMF\" /></properties>  </persistence-unit></persistence>";

    protected void assertClassloaderNotRegistered() {
        Assert.assertNull(ClassLoaderRef.getClassLoaderRef());
        Assert.assertNull(ClassLoaderRef.getModuleRef());
    }

    protected void assertClassloaderRegistered() {
        Assert.assertNotNull(ClassLoaderRef.getClassLoaderRef().get());
        Assert.assertNotNull(ClassLoaderRef.getModuleRef().get());
    }

    protected void assertClassloaderReleased() {
        System.gc();
        if (ClassLoaderRef.getClassLoaderRef().get() != null) {
            this.fillMemory(ClassLoaderRef.getClassLoaderRef());
        }
        if (ClassLoaderRef.getClassLoaderRef().get() != null) {
            this.fillMemory(ClassLoaderRef.getClassLoaderRef());
        }
        Assert.assertNull(ClassLoaderRef.getClassLoaderRef().get());
        Assert.assertNull(ClassLoaderRef.getModuleRef().get());
    }

    protected void clearClassloaderRefs() {
        ClassLoaderRef.setClassLoaderRef(null);
        ClassLoaderRef.setModuleRef(null);
    }

    protected static WebArchive prepareDriverWar() {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)DEPLOYMENT_DRIVER_NAME);
        war.addClass(AbstractClassloaderLeakTestBase.class);
        war.addClass(ClassLoaderRef.class);
        war.addClass(HttpRequest.class);
        war.addClass(TestSuiteEnvironment.class);
        return war;
    }

    protected static WebArchive prepareTestAppWar(String deploymentName) {
        WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)(deploymentName + ".war"));
        war.addClass(ClassLoaderServlet.class);
        war.addAsWebResource((Asset)new StringAsset("Hello world!"), "/index.jsp");
        return war;
    }

    protected static EnterpriseArchive prepareTestAppEar(String deploymentName, WebArchive war) {
        return AbstractClassloaderLeakTestBase.prepareTestAppEar(deploymentName, war, false);
    }

    protected static EnterpriseArchive prepareTestAppEar(String deploymentName, WebArchive war, boolean clustered) {
        EnterpriseArchive ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)(deploymentName + ".ear"));
        ear.addAsModule((Archive)war);
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)(deploymentName + "-ejb.jar"));
        jar.addClass(StatelessRemote.class);
        jar.addClass(clustered ? ClusteredStatelessBean.class : StatelessBean.class);
        jar.addClass(StatefulRemote.class);
        jar.addClass(clustered ? ClusteredStatefulBean.class : StatefulBean.class);
        jar.addClass(EntityBean.class);
        jar.addAsResource((Asset)new StringAsset(PERSISTENCE_XML), "META-INF/persistence.xml");
        ear.addAsModule((Archive)jar);
        return ear;
    }

    protected void testWar(String webURI) throws Exception {
        String response = HttpRequest.get(webURI + "/ClassloaderServlet", 10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)response.contains("ClassloaderServlet"));
        response = HttpRequest.get(webURI + "/index.jsp", 10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)response.contains("Hello world!"));
    }

    protected void testEjb(String deploymentName) throws Exception {
        this.testEjb(deploymentName, false);
    }

    protected void testEjb(String deploymentName, boolean clustered) throws Exception {
        InitialContext ctx = new InitialContext();
        StatelessRemote stateless = (StatelessRemote)ctx.lookup("java:global/" + deploymentName + "/" + deploymentName + (clustered ? "-ejb/ClusteredStatelessBean" : "-ejb/StatelessBean"));
        Long id = stateless.createEntity("Hello world!");
        String response = stateless.getEntity(id);
        Assert.assertTrue((boolean)response.contains("Hello world!"));
        StatefulRemote stateful = (StatefulRemote)ctx.lookup("java:global/" + deploymentName + "/" + deploymentName + (clustered ? "-ejb/ClusteredStatefulBean" : "-ejb/StatefulBean"));
        stateful.setState("Hello world!");
        response = (String)stateful.getState();
        Assert.assertTrue((boolean)response.contains("Hello world!"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillMemory(WeakReference<ClassLoader> ref) {
        Runtime rt = Runtime.getRuntime();
        int[] adds = new int[]{0, 10, 20, 30, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49};
        for (int i = 0; i < adds.length; ++i) {
            int toAdd = adds[i];
            System.gc();
            System.runFinalization();
            if (ref.get() == null) break;
            Object bytez = new byte[10000][];
            long avail = rt.freeMemory();
            int create = (int)(avail / 1000L * (long)(950 + toAdd));
            String pct = 95 + toAdd / 10 + "." + (toAdd - toAdd / 10 * 10);
            int bucket = create / 10000;
            log.info((Object)("Filling " + pct + "% of free memory. Free memory=" + avail + " Total Memory=" + rt.totalMemory() + " Max Memory=" + rt.maxMemory()));
            try {
                for (int j = 0; j < ((byte[][])bytez).length; ++j) {
                    bytez[j] = new byte[bucket];
                    if (j % 100 != 0 || ref.get() != null) continue;
                    return;
                }
                continue;
            }
            catch (Throwable t) {
                bytez = null;
                System.gc();
                System.runFinalization();
                log.warn((Object)("Caught throwable filling memory: " + t));
                break;
            }
            finally {
                bytez = null;
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException ignored) {
                    log.warn((Object)"Interrupted");
                    break;
                }
            }
        }
        try {
            ByteArrayOutputStream byteout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteout);
            out.writeObject(new Dummy());
            out.close();
            ByteArrayInputStream byteInput = new ByteArrayInputStream(byteout.toByteArray());
            ObjectInputStream input = new ObjectInputStream(byteInput);
            input.readObject();
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ref.get() != null) {
            System.gc();
            System.runFinalization();
        }
    }

    private static class Dummy
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private Dummy() {
        }
    }
}

