/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.jboss.dmr.ModelNode;

public class HttpMgmtProxy {
    private static final String APPLICATION_JSON = "application/json";
    private URL url;
    private HttpClient httpClient;
    private HttpContext httpContext = new BasicHttpContext();

    public HttpMgmtProxy(URL mgmtURL) {
        this.url = mgmtURL;
        DefaultHttpClient httpClient = new DefaultHttpClient();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials("testSuite", "testSuitePassword");
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.url.getHost(), this.url.getPort(), "ManagementRealm"), (Credentials)creds);
        this.httpClient = httpClient;
    }

    public ModelNode sendGetCommand(String cmd) throws Exception {
        HttpGet get = new HttpGet(this.url.toURI().toString() + cmd);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get, this.httpContext);
        String str = EntityUtils.toString((HttpEntity)response.getEntity());
        return ModelNode.fromJSONString((String)str);
    }

    public ModelNode sendPostCommand(String address, String operation) throws Exception {
        return this.sendPostCommand(HttpMgmtProxy.getOpNode(address, operation));
    }

    public ModelNode sendPostCommand(ModelNode cmd) throws Exception {
        String cmdStr = cmd.toJSONString(true);
        HttpPost post = new HttpPost(this.url.toURI());
        StringEntity entity = new StringEntity(cmdStr);
        entity.setContentType(APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)post, this.httpContext);
        String str = EntityUtils.toString((HttpEntity)response.getEntity());
        return ModelNode.fromJSONString((String)str);
    }

    public static ModelNode getOpNode(String address, String operation) {
        ModelNode op = new ModelNode();
        String[] pathSegments = address.split("/");
        ModelNode list = op.get("address").setEmptyList();
        for (String segment : pathSegments) {
            String[] elements = segment.split("=");
            list.add(elements[0], elements[1]);
        }
        op.get("operation").set(operation);
        return op;
    }
}

