/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.ManagementOperations;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.osgi.framework.Version;

public abstract class OSGiManagementOperations {
    public static void activateFramework(ModelControllerClient client) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "activate");
        OSGiManagementOperations.executeOperation(client, op);
    }

    public static String getActivationMode(ModelControllerClient client) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.readAttribute(client, "activation");
    }

    public static boolean setActivationMode(ModelControllerClient client, String mode) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.writeAttribute(client, "activation", mode);
    }

    public static Integer getFrameworkStartLevel(ModelControllerClient client) throws MgmtOperationException, IOException {
        String sl = OSGiManagementOperations.readAttribute(client, "startlevel");
        if (sl.trim().length() == 0) {
            return null;
        }
        return Integer.parseInt(sl);
    }

    public static boolean setFrameworkStartLevel(ModelControllerClient client, int i) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.writeAttribute(client, "startlevel", "" + i);
    }

    public static boolean bundleStart(ModelControllerClient client, Object resId) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/bundle=" + resId, "start");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    public static boolean bundleStop(ModelControllerClient client, Object resId) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/bundle=" + resId, "stop");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    public static List<Long> listBundleIDs(ModelControllerClient client) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "read-children-names");
        op.get("child-type").set("bundle");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, true);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ModelNode s : result.asList()) {
            ids.add(Long.parseLong(s.asString()));
        }
        return ids;
    }

    public static Long getBundleId(ModelControllerClient client, String symbolicName, Version version) throws MgmtOperationException, IOException {
        Long result = new Long(-1L);
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        ModelNode bundleNode = OSGiManagementOperations.executeOperation(client, op).get("bundle");
        for (ModelNode node : bundleNode.asList()) {
            Version auxver;
            Property propNode = node.asProperty();
            ModelNode valueNode = propNode.getValue();
            ModelNode symbolicNameNode = valueNode.get("symbolic-name");
            if (!symbolicNameNode.asString().equals(symbolicName)) continue;
            if (version == null) {
                result = new Long(propNode.getName());
                break;
            }
            ModelNode versionNode = valueNode.get("version");
            if (!versionNode.isDefined() || !version.equals((Object)(auxver = Version.parseVersion((String)versionNode.asString())))) continue;
            result = new Long(propNode.getName());
            break;
        }
        return result;
    }

    public static String getBundleState(ModelControllerClient client, Object resId) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/bundle=" + resId, "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op);
        return result.get("state").asString();
    }

    public static ModelNode getBundleInfo(ModelControllerClient client, Object resId) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/bundle=" + resId, "read-resource");
        op.get("include-runtime").set("true");
        op.get("recursive").set("true");
        return OSGiManagementOperations.executeOperation(client, op);
    }

    public static boolean addCapability(ModelControllerClient client, String name, Integer startLevel) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/capability=" + name, "add");
        op.get("startlevel").set(startLevel.toString());
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    public static List<String> listCapabilities(ModelControllerClient client) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.listChildrenNames(client, "capability");
    }

    public static boolean removeCapability(ModelControllerClient client, String name) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.removeResource(client, "capability", name);
    }

    public static boolean addProperty(ModelControllerClient client, String name, String value) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/property=" + name, "add");
        op.get("value").set(value);
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    public static List<String> listProperties(ModelControllerClient client) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.listChildrenNames(client, "property");
    }

    public static String readProperty(ModelControllerClient client, String name) throws MgmtOperationException, IOException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/property=" + name, "read-resource");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op);
        return result.get("value").asString();
    }

    public static boolean removeProperty(ModelControllerClient client, String name) throws MgmtOperationException, IOException {
        return OSGiManagementOperations.removeResource(client, "property", name);
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op) throws IOException, MgmtOperationException {
        return OSGiManagementOperations.executeOperation(client, op, true);
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws IOException, MgmtOperationException {
        System.out.println(op);
        ModelNode result = unwrapResult ? ManagementOperations.executeOperation(client, op) : ManagementOperations.executeOperationRaw(client, op);
        System.out.println(result);
        return result;
    }

    private static List<String> listChildrenNames(ModelControllerClient client, String type) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "read-children-names");
        op.get("child-type").set(type);
        ModelNode result = OSGiManagementOperations.executeOperation(client, op);
        ArrayList<String> names = new ArrayList<String>();
        for (ModelNode n : result.asList()) {
            names.add(n.asString());
        }
        return names;
    }

    private static boolean removeResource(ModelControllerClient client, String type, String name) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi/" + type + "=" + name, "remove");
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }

    private static String readAttribute(ModelControllerClient client, String attributeName) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "read-attribute");
        op.get("name").set(attributeName);
        ModelNode result = OSGiManagementOperations.executeOperation(client, op);
        return result.asString();
    }

    private static boolean writeAttribute(ModelControllerClient client, String attributeName, String value) throws IOException, MgmtOperationException {
        ModelNode op = ModelUtil.createOpNode("subsystem=osgi", "write-attribute");
        op.get("name").set(attributeName);
        op.get("value").set(value);
        ModelNode result = OSGiManagementOperations.executeOperation(client, op, false);
        return "success".equals(result.get("outcome").asString());
    }
}

