/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.osgi;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public final class OSGiFrameworkUtils {
    private OSGiFrameworkUtils() {
    }

    public static void changeStartLevel(BundleContext context, final int level, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        final StartLevel startLevel = (StartLevel)context.getService(sref);
        if (level != startLevel.getStartLevel()) {
            final CountDownLatch latch = new CountDownLatch(1);
            context.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8 && level == startLevel.getStartLevel()) {
                        latch.countDown();
                    }
                }
            });
            startLevel.setStartLevel(level);
            if (!latch.await(timeout, units)) {
                throw new TimeoutException("Timeout changing start level");
            }
        }
    }

    public static Bundle getDeployedBundle(BundleContext context, String symbolicName, String versionRange) {
        ServiceReference sref = context.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin packageAdmin = (PackageAdmin)context.getService(sref);
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, versionRange);
        Assert.assertNotNull((String)"Bundles found", (Object)bundles);
        Assert.assertEquals((String)"One bundle found", (long)1L, (long)bundles.length);
        return bundles[0];
    }
}

