/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.util.ArrayList;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class RolloutPlanBuilder {
    ArrayList series = new ArrayList();
    private boolean rollBackAcrossGroups = false;

    public void addGroup(String groupName, RolloutPolicy policy) {
        this.series.add(new Object[]{groupName, policy});
    }

    public void addConcurrentGroups(Map<String, RolloutPolicy> concurrentGroups) {
        this.series.add(concurrentGroups);
    }

    public String buildAsString() {
        ModelNode plan = this.build();
        String planString = plan.toString();
        planString = planString.replace("\n", " ");
        return planString;
    }

    public ModelNode build() {
        ModelNode plan = new ModelNode();
        for (Object step : this.series) {
            if (step instanceof Object[]) {
                Object[] pair = (Object[])step;
                String groupName = (String)pair[0];
                RolloutPolicy policy = (RolloutPolicy)pair[1];
                ModelNode group = new ModelNode();
                group.get(groupName).set(policy.toModelNode());
                ModelNode serverGroup = new ModelNode();
                serverGroup.get("server-group").set(group);
                plan.get("in-series").add(serverGroup);
                continue;
            }
            Map concurrentGroups = (Map)step;
            ModelNode groups = new ModelNode();
            for (String groupName : concurrentGroups.keySet()) {
                ModelNode group = new ModelNode();
                group.get(groupName).set(((RolloutPolicy)concurrentGroups.get(groupName)).toModelNode());
                groups.get(groupName).set(group);
            }
            ModelNode concurrentGroupsNode = new ModelNode();
            concurrentGroupsNode.get("concurrent-groups").set(groups);
            plan.get("in-series").add(concurrentGroupsNode);
        }
        plan.get("rollback-across-groups").set(this.rollBackAcrossGroups);
        ModelNode rolloutPlan = new ModelNode();
        rolloutPlan.get("rollout-plan").set(plan);
        return rolloutPlan;
    }

    public void setRollBackAcrossGroups(boolean rollBackAcrossGroups) {
        this.rollBackAcrossGroups = rollBackAcrossGroups;
    }

    public static class RolloutPolicy {
        private final boolean rollingToServers;
        private final Integer maxFailurePercentage;
        private final Integer maxFailedServers;

        public RolloutPolicy(boolean rollingToServers, Integer maxFailurePercentage, Integer maxFailedServers) {
            this.rollingToServers = rollingToServers;
            this.maxFailurePercentage = maxFailurePercentage;
            this.maxFailedServers = maxFailedServers;
        }

        public ModelNode toModelNode() {
            ModelNode node = new ModelNode();
            node.get("rolling-to-servers").set(this.rollingToServers);
            if (this.maxFailedServers != null) {
                node.get("max-failed-servers").set(this.maxFailedServers.intValue());
            }
            if (this.maxFailurePercentage != null) {
                node.get("max-failure-percentage").set(this.maxFailurePercentage.intValue());
            }
            return node;
        }
    }
}

