/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management;

import java.io.IOException;
import java.util.List;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.test.integration.management.util.MgmtOperationException;
import org.jboss.dmr.ModelNode;

public class ManagementOperations {
    private ManagementOperations() {
    }

    public static void executeOperations(ModelControllerClient client, List<ModelNode> operations) throws IOException, MgmtOperationException {
        for (ModelNode op : operations) {
            ManagementOperations.executeOperation(client, op);
        }
    }

    public static ModelNode executeOperation(ModelControllerClient client, ModelNode op) throws IOException, MgmtOperationException {
        return ManagementOperations.executeOperation(client, op, true);
    }

    public static ModelNode executeOperation(ModelControllerClient client, Operation op) throws IOException, MgmtOperationException {
        return ManagementOperations.executeOperation(client, op, true);
    }

    public static ModelNode executeOperationRaw(ModelControllerClient client, ModelNode op) throws IOException {
        try {
            return ManagementOperations.executeOperation(client, op, false);
        }
        catch (MgmtOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static ModelNode executeOperation(ModelControllerClient client, ModelNode op, boolean unwrapResult) throws IOException, MgmtOperationException {
        ModelNode ret = client.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new MgmtOperationException("Management operation failed: " + ret.get("failure-description"), op, ret);
        }
        return ret.get("result");
    }

    private static ModelNode executeOperation(ModelControllerClient client, Operation op, boolean unwrapResult) throws IOException, MgmtOperationException {
        ModelNode ret = client.execute(op);
        if (!unwrapResult) {
            return ret;
        }
        if (!"success".equals(ret.get("outcome").asString())) {
            throw new MgmtOperationException("Management operation failed: " + ret.get("failure-description"), op.getOperation(), ret);
        }
        return ret.get("result");
    }
}

