/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    protected static void setSystemProperty(String name, String value) {
        TCLAction.UTIL.setSystemProperty(name, value);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public void setSystemProperty(String name, String value) {
                System.setProperty(name, value);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }

            @Override
            public void setSystemProperty(final String name, final String value) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.setProperty(name, value);
                        return null;
                    }
                });
            }
        };

        public String getSystemProperty(String var1);

        public void setSystemProperty(String var1, String var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            public static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }

            public static void setSystemProperty(String name, String value) {
                UTIL.getTCLAction().setSystemProperty(name, value);
            }
        }
    }
}

