/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.osgi;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.startlevel.StartLevel;
import org.osgi.util.tracker.ServiceTracker;

public final class FrameworkUtils {
    private FrameworkUtils() {
    }

    public static void changeStartLevel(BundleContext context, int level) throws InterruptedException, TimeoutException {
        FrameworkUtils.changeStartLevel(context, level, 10L, TimeUnit.SECONDS);
    }

    public static void changeStartLevel(BundleContext context, final int level, long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        ServiceReference sref = context.getServiceReference(StartLevel.class.getName());
        final StartLevel startLevel = (StartLevel)context.getService(sref);
        if (level != startLevel.getStartLevel()) {
            final CountDownLatch latch = new CountDownLatch(1);
            context.addFrameworkListener(new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    if (event.getType() == 8 && level == startLevel.getStartLevel()) {
                        latch.countDown();
                    }
                }
            });
            startLevel.setStartLevel(level);
            if (!latch.await(timeout, units)) {
                throw new TimeoutException("Timeout changing start level");
            }
        }
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz) {
        return FrameworkUtils.waitForService(context, clazz, 10L, TimeUnit.SECONDS);
    }

    public static <T> T waitForService(BundleContext context, Class<T> clazz, long timeout, TimeUnit unit) {
        ServiceReference sref = FrameworkUtils.waitForServiceReference(context, clazz, timeout, unit);
        Object service = sref != null ? context.getService(sref) : null;
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), (Object)service);
        return (T)service;
    }

    public static ServiceReference waitForServiceReference(BundleContext context, Class<?> clazz) {
        return FrameworkUtils.waitForServiceReference(context, clazz, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceReference waitForServiceReference(BundleContext context, Class<?> clazz, long timeout, TimeUnit unit) {
        ServiceTracker tracker = new ServiceTracker(context, clazz.getName(), null);
        tracker.open();
        ServiceReference sref = null;
        try {
            if (tracker.waitForService(unit.toMillis(timeout)) != null) {
                sref = context.getServiceReference(clazz.getName());
            }
        }
        catch (InterruptedException e) {
        }
        finally {
            tracker.close();
        }
        Assert.assertNotNull((String)("Service registered: " + clazz.getName()), (Object)sref);
        return sref;
    }
}

