/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import javax.xml.stream.XMLStreamException;
import org.jboss.as.threads.AbstractExecutorElement;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.BoundedQueueThreadPoolAdd;
import org.jboss.as.threads.ScaledCount;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class BoundedQueueThreadPoolElement
extends AbstractExecutorElement<BoundedQueueThreadPoolElement> {
    private static final long serialVersionUID = -6314205265652284301L;
    private String handoffExecutor;
    private boolean blocking;
    private boolean allowCoreTimeout;
    private ScaledCount queueLength;
    private ScaledCount coreThreads;

    public BoundedQueueThreadPoolElement(String name) {
        super(name);
    }

    protected Class<BoundedQueueThreadPoolElement> getElementClass() {
        return BoundedQueueThreadPoolElement.class;
    }

    public String getHandoffExecutor() {
        return this.handoffExecutor;
    }

    void setHandoffExecutor(String handoffExecutor) {
        this.handoffExecutor = handoffExecutor;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public boolean isAllowCoreTimeout() {
        return this.allowCoreTimeout;
    }

    void setAllowCoreTimeout(boolean allowCoreTimeout) {
        this.allowCoreTimeout = allowCoreTimeout;
    }

    public ScaledCount getQueueLength() {
        return this.queueLength;
    }

    void setQueueLength(ScaledCount queueLength) {
        this.queueLength = queueLength;
    }

    public ScaledCount getCoreThreads() {
        return this.coreThreads;
    }

    void setCoreThreads(ScaledCount coreThreads) {
        this.coreThreads = coreThreads;
    }

    @Override
    protected void writeAttributes(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        super.writeAttributes(streamWriter);
        if (this.blocking) {
            streamWriter.writeAttribute("blocking", "true");
        }
        if (this.allowCoreTimeout) {
            streamWriter.writeAttribute("allow-core-timeout", "true");
        }
    }

    @Override
    protected void writeElements(XMLExtendedStreamWriter streamWriter) throws XMLStreamException {
        if (this.handoffExecutor != null) {
            streamWriter.writeEmptyElement("handoff-executor");
            streamWriter.writeAttribute("name", this.handoffExecutor);
        }
        if (this.coreThreads != null) {
            BoundedQueueThreadPoolElement.writeScaledCountElement(streamWriter, this.coreThreads, "core-threads");
        }
        BoundedQueueThreadPoolElement.writeScaledCountElement(streamWriter, this.queueLength, "queue-length");
        super.writeElements(streamWriter);
    }

    @Override
    AbstractThreadsSubsystemUpdate<Void> getAdd() {
        BoundedQueueThreadPoolAdd add = new BoundedQueueThreadPoolAdd(this.getName(), this.getMaxThreads(), this.getQueueLength());
        add.setKeepaliveTime(this.getKeepaliveTime());
        add.setThreadFactory(this.getThreadFactory());
        add.setBlocking(this.blocking);
        add.setHandoffExecutor(this.handoffExecutor);
        add.setAllowCoreTimeout(this.allowCoreTimeout);
        add.setCoreThreads(this.coreThreads);
        add.getProperties().putAll(this.getProperties());
        return add;
    }
}

