/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    BOUNDED_QUEUE_THREAD_POOL("bounded-queue-thread-pool"),
    CORE_THREADS("core-threads"),
    HANDOFF_EXECUTOR("handoff-executor"),
    KEEPALIVE_TIME("keepalive-time"),
    MAX_THREADS("max-threads"),
    PROPERTIES("properties"),
    PROPERTY("property"),
    QUEUE_LENGTH("queue-length"),
    QUEUELESS_THREAD_POOL("queueless-thread-pool"),
    SCHEDULED_THREAD_POOL("scheduled-thread-pool"),
    SUBSYSTEM("subsystem"),
    THREAD_FACTORY("thread-factory"),
    UNBOUNDED_QUEUE_THREAD_POOL("unbounded-queue-thread-pool");

    private final String name;
    private static final Map<String, Element> MAP;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = MAP.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        MAP = map;
    }
}

