/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractExecutorElement;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public final class ExecutorRemove
extends AbstractThreadsSubsystemUpdate<Void> {
    private static final long serialVersionUID = 3661832034337989182L;
    private final String name;

    protected ExecutorRemove(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public AbstractThreadsSubsystemUpdate<Void> getCompensatingUpdate(ThreadsSubsystemElement original) {
        AbstractExecutorElement<?> element = original.getExecutor(this.name);
        return element == null ? null : element.getAdd();
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        element.removeExecutor(this.name);
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController controller = updateContext.getServiceContainer().getService(ThreadsServices.executorName(this.name));
        if (controller == null) {
            handler.handleSuccess(null, param);
            return;
        }
        controller.addListener((ServiceListener)new UpdateResultHandler.ServiceRemoveListener(handler, param));
    }
}

