/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.model.AbstractModelElement;
import org.jboss.as.model.ChildElement;
import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractExecutorAdd;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.QueuelessThreadPoolElement;
import org.jboss.as.threads.QueuelessThreadPoolService;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.BatchBuilder;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;

public final class QueuelessThreadPoolAdd
extends AbstractExecutorAdd {
    private static final long serialVersionUID = 5597662601486525937L;
    private String handoffExecutor;
    private boolean blocking;

    public QueuelessThreadPoolAdd(String name, ScaledCount maxThreads) {
        super(name, maxThreads);
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        BatchBuilder builder = updateContext.getBatchBuilder();
        ScaledCount maxThreadsCount = this.getMaxThreads();
        int maxThreads = maxThreadsCount.getScaledCount();
        String name = this.getName();
        ServiceName serviceName = ThreadsServices.executorName(name);
        QueuelessThreadPoolService service = new QueuelessThreadPoolService(maxThreads, this.blocking, this.getKeepaliveTime());
        BatchServiceBuilder serviceBuilder = builder.addService(serviceName, (Service)service);
        this.addThreadFactoryDependency(serviceName, serviceBuilder, service.getThreadFactoryInjector(), builder);
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        QueuelessThreadPoolElement poolElement = new QueuelessThreadPoolElement(this.getName());
        poolElement.setBlocking(this.blocking);
        poolElement.setHandoffExecutor(this.handoffExecutor);
        poolElement.setKeepaliveTime(this.getKeepaliveTime());
        poolElement.setThreadFactory(this.getThreadFactory());
        poolElement.setMaxThreads(this.getMaxThreads());
        element.addExecutor(this.getName(), new ChildElement(Element.QUEUELESS_THREAD_POOL.getLocalName(), (AbstractModelElement)poolElement));
    }

    public String getHandoffExecutor() {
        return this.handoffExecutor;
    }

    public void setHandoffExecutor(String handoffExecutor) {
        this.handoffExecutor = handoffExecutor;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }
}

