/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import org.jboss.as.model.UpdateContext;
import org.jboss.as.model.UpdateFailedException;
import org.jboss.as.model.UpdateResultHandler;
import org.jboss.as.threads.AbstractThreadsSubsystemUpdate;
import org.jboss.as.threads.ThreadFactoryElement;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.ThreadsSubsystemElement;
import org.jboss.msc.service.ServiceController;

public final class ThreadFactoryThreadNamePatternUpdate
extends AbstractThreadsSubsystemUpdate<Void> {
    private static final long serialVersionUID = 4253625376544201028L;
    private final String name;
    private final String newNamePattern;

    public ThreadFactoryThreadNamePatternUpdate(String name, String newNamePattern) {
        this.name = name;
        this.newNamePattern = newNamePattern;
    }

    public ThreadFactoryThreadNamePatternUpdate getCompensatingUpdate(ThreadsSubsystemElement original) {
        ThreadFactoryElement threadFactory = original.getThreadFactory(this.name);
        if (threadFactory == null) {
            return null;
        }
        return new ThreadFactoryThreadNamePatternUpdate(this.name, threadFactory.getGroupName());
    }

    protected <P> void applyUpdate(UpdateContext updateContext, UpdateResultHandler<? super Void, P> handler, P param) {
        ServiceController service = updateContext.getServiceContainer().getService(ThreadsServices.threadFactoryName(this.name));
        if (service == null) {
            handler.handleFailure((Throwable)this.notConfigured(), param);
        } else {
            try {
                ThreadFactoryService threadFactoryService = (ThreadFactoryService)service.getValue();
                threadFactoryService.setNamePattern(this.newNamePattern);
                handler.handleSuccess(null, param);
            }
            catch (Throwable t) {
                handler.handleFailure(t, param);
            }
        }
    }

    protected void applyUpdate(ThreadsSubsystemElement element) throws UpdateFailedException {
        ThreadFactoryElement threadFactory = element.getThreadFactory(this.name);
        if (threadFactory == null) {
            throw this.notConfigured();
        }
        threadFactory.setThreadNamePattern(this.newNamePattern);
    }

    public String getName() {
        return this.name;
    }

    public String getNewNamePattern() {
        return this.newNamePattern;
    }

    private UpdateFailedException notConfigured() {
        return new UpdateFailedException("No thread factory named " + this.name + " is configured");
    }
}

