/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.threads.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

class ThreadsSubsystemProviders {
    static final String RESOURCE_NAME = ThreadsSubsystemProviders.class.getPackage().getName() + ".LocalDescriptions";
    static final DescriptionProvider SUBSYSTEM_PROVIDER = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode subsystem = new ModelNode();
            subsystem.get("description").set(bundle.getString("threads"));
            subsystem.get("head-comment-allowed").set(true);
            subsystem.get("tail-comment-allowed").set(true);
            subsystem.get("namespace").set(Namespace.THREADS_1_0.getUriString());
            subsystem.get(new String[]{"children", "thread-factory", "description"}).set(bundle.getString("threadfactories"));
            subsystem.get(new String[]{"children", "thread-factory", "required"}).set(false);
            subsystem.get(new String[]{"children", "unbounded-queue-thread-pool", "description"}).set(bundle.getString("threadpool.unbounded"));
            subsystem.get(new String[]{"children", "unbounded-queue-thread-pool", "required"}).set(false);
            subsystem.get(new String[]{"children", "bounded-queue-thread-pool", "description"}).set(bundle.getString("threadpool.bounded"));
            subsystem.get(new String[]{"children", "bounded-queue-thread-pool", "required"}).set(false);
            subsystem.get(new String[]{"children", "queueless-thread-pool", "description"}).set(bundle.getString("threadpool.queueless"));
            subsystem.get(new String[]{"children", "queueless-thread-pool", "required"}).set(false);
            subsystem.get(new String[]{"children", "scheduled-thread-pool", "description"}).set(bundle.getString("threadpool.scheduled"));
            subsystem.get(new String[]{"children", "scheduled-thread-pool", "required"}).set(false);
            return subsystem;
        }
    };
    static final DescriptionProvider THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode node = new ModelNode();
            node.get("description").set(bundle.getString("threadfactory"));
            node.get("head-comment-allowed").set(true);
            node.get("tail-comment-allowed").set(true);
            node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("threadfactory.name"));
            node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "name", "required"}).set(true);
            node.get(new String[]{"attributes", "group-name", "description"}).set(bundle.getString("threadfactory.groupname"));
            node.get(new String[]{"attributes", "group-name", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "group-name", "required"}).set(false);
            node.get(new String[]{"attributes", "thread-name-pattern", "description"}).set(bundle.getString("threadfactory.threadnamepattern"));
            node.get(new String[]{"attributes", "thread-name-pattern", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "thread-name-pattern", "required"}).set(false);
            node.get(new String[]{"attributes", "priority", "description"}).set(bundle.getString("threadfactory.priority"));
            node.get(new String[]{"attributes", "priority", "type"}).set(ModelType.INT);
            node.get(new String[]{"attributes", "priority", "required"}).set(false);
            node.get(new String[]{"attributes", "properties", "description"}).set(bundle.getString("threadfactory.properties"));
            node.get(new String[]{"attributes", "properties", "type"}).set(ModelType.LIST);
            node.get(new String[]{"attributes", "properties", "value-type"}).set(ModelType.PROPERTY);
            node.get(new String[]{"attributes", "properties", "required"}).set(false);
            return node;
        }
    };
    static DescriptionProvider BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonThreadPool(bundle, bundle.getString("threadpool.bounded.description"));
            operation.get(new String[]{"attributes", "blocking", "description"}).set(bundle.getString("threadpool.bounded.blocking"));
            operation.get(new String[]{"attributes", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"attributes", "blocking", "required"}).set(false);
            operation.get(new String[]{"attributes", "allow-core-timeout", "description"}).set(bundle.getString("threadpool.bounded.allowcoretimeout"));
            operation.get(new String[]{"attributes", "allow-core-timeout", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"attributes", "allow-core-timeout", "required"}).set(false);
            operation.get(new String[]{"attributes", "handoff-executor", "description"}).set(bundle.getString("threadpool.bounded.handoffexecutor"));
            operation.get(new String[]{"attributes", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"attributes", "handoff-executor", "required"}).set(false);
            operation.get(new String[]{"attributes", "core-threads", "description"}).set(bundle.getString("threadpool.bounded.corethreads"));
            operation.get(new String[]{"attributes", "core-threads", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"attributes", "core-threads", "required"}).set(false);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "description"}).set(bundle.getString("threadpool.bounded.corethreads.count"));
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.bounded.corethreads.percpu"));
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"attributes", "core-threads", "value-type", "per-cpu", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "description"}).set(bundle.getString("threadpool.bounded.queuelength"));
            operation.get(new String[]{"attributes", "queue-length", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"attributes", "queue-length", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "description"}).set(bundle.getString("threadpool.bounded.queuelength.count"));
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.bounded.queuelength.percpu"));
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"attributes", "queue-length", "value-type", "per-cpu", "required"}).set(true);
            return operation;
        }
    };
    static final DescriptionProvider UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonThreadPool(bundle, bundle.getString("threadpool.unbounded.description"));
        }
    };
    static final DescriptionProvider QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode node = ThreadsSubsystemProviders.getCommonThreadPool(bundle, bundle.getString("threadpool.queueless.description"));
            node.get(new String[]{"attributes", "blocking", "description"}).set(bundle.getString("threadpool.queueless.blocking"));
            node.get(new String[]{"attributes", "blocking", "type"}).set(ModelType.BOOLEAN);
            node.get(new String[]{"attributes", "blocking", "required"}).set(true);
            node.get(new String[]{"attributes", "handoff-executor", "description"}).set(bundle.getString("threadpool.queueless.handoffexecutor"));
            node.get(new String[]{"attributes", "handoff-executor", "type"}).set(ModelType.STRING);
            node.get(new String[]{"attributes", "handoff-executor", "required"}).set(true);
            return node;
        }
    };
    static final DescriptionProvider SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonThreadPool(bundle, bundle.getString("threadpool.scheduled.description"));
        }
    };
    static final DescriptionProvider SUBSYSTEM_ADD_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("threads.add"));
            operation.get("request-properties").setEmptyObject();
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider ADD_THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("add");
            operation.get("description").set(bundle.getString("threadfactory.add"));
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("threadfactory.name"));
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            operation.get(new String[]{"request-properties", "group-name", "description"}).set(bundle.getString("threadfactory.groupname"));
            operation.get(new String[]{"request-properties", "group-name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "group-name", "required"}).set(false);
            operation.get(new String[]{"request-properties", "thread-name-pattern", "description"}).set(bundle.getString("threadfactory.threadnamepattern"));
            operation.get(new String[]{"request-properties", "thread-name-pattern", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "thread-name-pattern", "required"}).set(false);
            operation.get(new String[]{"request-properties", "priority", "description"}).set(bundle.getString("threadfactory.priority"));
            operation.get(new String[]{"request-properties", "priority", "type"}).set(ModelType.INT);
            operation.get(new String[]{"request-properties", "priority", "required"}).set(false);
            operation.get(new String[]{"request-properties", "properties", "description"}).set(bundle.getString("threadfactory.properties"));
            operation.get(new String[]{"request-properties", "properties", "type"}).set(ModelType.LIST);
            operation.get(new String[]{"request-properties", "properties", "value-type"}).set(ModelType.PROPERTY);
            operation.get(new String[]{"request-properties", "properties", "required"}).set(false);
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider REMOVE_THREAD_FACTORY_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = new ModelNode();
            operation.get("operation-name").set("remove");
            operation.get("description").set(bundle.getString("threadfactory.remove"));
            operation.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("threadfactory.remove"));
            operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "name", "required"}).set(true);
            operation.get("reply-properties").setEmptyObject();
            return operation;
        }
    };
    static DescriptionProvider ADD_BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonAddThreadPool(bundle, "add", bundle.getString("threadpool.bounded.add"));
            operation.get(new String[]{"request-properties", "blocking", "description"}).set(bundle.getString("threadpool.bounded.blocking"));
            operation.get(new String[]{"request-properties", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "blocking", "required"}).set(false);
            operation.get(new String[]{"request-properties", "allow-core-timeout", "description"}).set(bundle.getString("threadpool.bounded.allowcoretimeout"));
            operation.get(new String[]{"request-properties", "allow-core-timeout", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "allow-core-timeout", "required"}).set(false);
            operation.get(new String[]{"request-properties", "handoff-executor", "description"}).set(bundle.getString("threadpool.bounded.handoffexecutor"));
            operation.get(new String[]{"request-properties", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "handoff-executor", "required"}).set(false);
            operation.get(new String[]{"request-properties", "core-threads", "description"}).set(bundle.getString("threadpool.bounded.corethreads"));
            operation.get(new String[]{"request-properties", "core-threads", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"request-properties", "core-threads", "required"}).set(false);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "description"}).set(bundle.getString("threadpool.bounded.corethreads.count"));
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.bounded.corethreads.percpu"));
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"request-properties", "core-threads", "value-type", "per-cpu", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "description"}).set(bundle.getString("threadpool.bounded.queuelength"));
            operation.get(new String[]{"request-properties", "queue-length", "type"}).set(ModelType.OBJECT);
            operation.get(new String[]{"request-properties", "queue-length", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "description"}).set(bundle.getString("threadpool.bounded.queuelength.count"));
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "count", "required"}).set(true);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.bounded.queuelength.percpu"));
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
            operation.get(new String[]{"request-properties", "queue-length", "value-type", "per-cpu", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider ADD_QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            ModelNode operation = ThreadsSubsystemProviders.getCommonAddThreadPool(bundle, "add", bundle.getString("threadpool.queueless.add"));
            operation.get(new String[]{"request-properties", "blocking", "description"}).set(bundle.getString("threadpool.queueless.blocking"));
            operation.get(new String[]{"request-properties", "blocking", "type"}).set(ModelType.BOOLEAN);
            operation.get(new String[]{"request-properties", "blocking", "required"}).set(true);
            operation.get(new String[]{"request-properties", "handoff-executor", "description"}).set(bundle.getString("threadpool.queueless.handoffexecutor"));
            operation.get(new String[]{"request-properties", "handoff-executor", "type"}).set(ModelType.STRING);
            operation.get(new String[]{"request-properties", "handoff-executor", "required"}).set(true);
            return operation;
        }
    };
    static DescriptionProvider ADD_UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonAddThreadPool(bundle, "add", bundle.getString("threadpool.unbounded.add"));
        }
    };
    static DescriptionProvider ADD_SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonAddThreadPool(bundle, "add", bundle.getString("threadpool.scheduled.add"));
        }
    };
    static DescriptionProvider REMOVE_BOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle, "remove", bundle.getString("threadpool.bounded.remove"));
        }
    };
    static DescriptionProvider REMOVE_QUEUELESS_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle, "remove", bundle.getString("threadpool.queueless.remove"));
        }
    };
    static DescriptionProvider REMOVE_UNBOUNDED_QUEUE_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle, "remove", bundle.getString("threadpool.unbounded.remove"));
        }
    };
    static DescriptionProvider REMOVE_SCHEDULED_THREAD_POOL_DESC = new DescriptionProvider(){

        public ModelNode getModelDescription(Locale locale) {
            ResourceBundle bundle = ThreadsSubsystemProviders.getResourceBundle(locale);
            return ThreadsSubsystemProviders.getCommonRemoveThreadPool(bundle, "remove", bundle.getString("threadpool.scheduled.remove"));
        }
    };

    ThreadsSubsystemProviders() {
    }

    private static ModelNode getCommonThreadPool(ResourceBundle bundle, String description) {
        ModelNode node = new ModelNode();
        node.get("description").set(description);
        node.get("head-comment-allowed").set(true);
        node.get("tail-comment-allowed").set(true);
        node.get(new String[]{"attributes", "name", "description"}).set(bundle.getString("threadpool.common.name"));
        node.get(new String[]{"attributes", "name", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "name", "required"}).set(true);
        node.get(new String[]{"attributes", "thread-factory", "description"}).set(bundle.getString("threadpool.common.threadfactory"));
        node.get(new String[]{"attributes", "thread-factory", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "thread-factory", "required"}).set(false);
        node.get(new String[]{"attributes", "properties", "description"}).set(bundle.getString("threadpool.common.properties"));
        node.get(new String[]{"attributes", "properties", "type"}).set(ModelType.LIST);
        node.get(new String[]{"attributes", "properties", "value-type"}).set(ModelType.PROPERTY);
        node.get(new String[]{"attributes", "properties", "required"}).set(false);
        node.get(new String[]{"attributes", "max-threads", "description"}).set(bundle.getString("threadpool.common.maxthreads"));
        node.get(new String[]{"attributes", "max-threads", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "max-threads", "required"}).set(true);
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "description"}).set(bundle.getString("threadpool.common.maxthreads.count"));
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
        node.get(new String[]{"attributes", "max-threads", "value-type", "count", "required"}).set(true);
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.common.maxthreads.percpu"));
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
        node.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "required"}).set(true);
        node.get(new String[]{"attributes", "keepalive-time", "description"}).set(bundle.getString("threadpool.common.keepalive"));
        node.get(new String[]{"attributes", "keepalive-time", "type"}).set(ModelType.OBJECT);
        node.get(new String[]{"attributes", "keepalive-time", "required"}).set(false);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "description"}).set(bundle.getString("threadpool.common.keepalive.time"));
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "type"}).set(ModelType.LONG);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "required"}).set(true);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "description"}).set(bundle.getString("threadpool.common.keepalive.unit"));
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "type"}).set(ModelType.STRING);
        node.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "required"}).set(true);
        return node;
    }

    static ModelNode getCommonAddThreadPool(ResourceBundle bundle, String operationName, String description) {
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set(operationName);
        operation.get("description").set(description);
        operation.get(new String[]{"request-properties", "name", "description"}).set(bundle.getString("threadpool.common.name"));
        operation.get(new String[]{"request-properties", "name", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "name", "required"}).set(true);
        operation.get(new String[]{"request-properties", "thread-factory", "description"}).set(bundle.getString("threadpool.common.threadfactory"));
        operation.get(new String[]{"request-properties", "thread-factory", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"request-properties", "thread-factory", "required"}).set(false);
        operation.get(new String[]{"request-properties", "properties", "description"}).set(bundle.getString("threadpool.common.properties"));
        operation.get(new String[]{"request-properties", "properties", "type"}).set(ModelType.LIST);
        operation.get(new String[]{"request-properties", "properties", "value-type"}).set(ModelType.PROPERTY);
        operation.get(new String[]{"request-properties", "properties", "required"}).set(false);
        operation.get(new String[]{"attributes", "max-threads", "description"}).set(bundle.getString("threadpool.common.maxthreads"));
        operation.get(new String[]{"attributes", "max-threads", "type"}).set(ModelType.OBJECT);
        operation.get(new String[]{"attributes", "max-threads", "required"}).set(true);
        operation.get(new String[]{"attributes", "max-threads", "value-type", "count", "description"}).set(bundle.getString("threadpool.common.maxthreads.count"));
        operation.get(new String[]{"attributes", "max-threads", "value-type", "count", "type"}).set(ModelType.BIG_DECIMAL);
        operation.get(new String[]{"attributes", "max-threads", "value-type", "count", "required"}).set(true);
        operation.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "description"}).set(bundle.getString("threadpool.common.maxthreads.percpu"));
        operation.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "type"}).set(ModelType.BIG_DECIMAL);
        operation.get(new String[]{"attributes", "max-threads", "value-type", "per-cpu", "required"}).set(true);
        operation.get(new String[]{"attributes", "keepalive-time", "description"}).set(bundle.getString("threadpool.common.keepalive"));
        operation.get(new String[]{"attributes", "keepalive-time", "type"}).set(ModelType.OBJECT);
        operation.get(new String[]{"attributes", "keepalive-time", "required"}).set(false);
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "description"}).set(bundle.getString("threadpool.common.keepalive.time"));
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "type"}).set(ModelType.LONG);
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "time", "required"}).set(true);
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "description"}).set(bundle.getString("threadpool.common.keepalive.unit"));
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "type"}).set(ModelType.STRING);
        operation.get(new String[]{"attributes", "keepalive-time", "value-type", "unit", "required"}).set(true);
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    private static ModelNode getCommonRemoveThreadPool(ResourceBundle bundle, String operationName, String description) {
        ModelNode operation = new ModelNode();
        operation.get("operation-name").set(operationName);
        operation.get("description").set(description);
        operation.get("reply-properties").setEmptyObject();
        return operation;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

