/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.threads.TimeSpec;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.threads.EventListener;
import org.jboss.threads.JBossExecutors;
import org.jboss.threads.QueuelessExecutor;

public class QueuelessThreadPoolService
implements Service<ExecutorService> {
    private final InjectedValue<ThreadFactory> threadFactoryValue = new InjectedValue();
    private final InjectedValue<Executor> handoffExecutorValue = new InjectedValue();
    private QueuelessExecutor executor;
    private ExecutorService value;
    private int maxThreads;
    private boolean blocking;
    private TimeSpec keepAlive;

    public QueuelessThreadPoolService(int maxThreads, boolean blocking, TimeSpec keepAlive) {
        this.maxThreads = maxThreads;
        this.blocking = blocking;
        this.keepAlive = keepAlive;
    }

    public synchronized void start(StartContext context) throws StartException {
        TimeSpec keepAliveSpec = this.keepAlive;
        long keepAlive = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getUnit().toMillis(keepAliveSpec.getDuration());
        this.executor = new QueuelessExecutor((ThreadFactory)this.threadFactoryValue.getValue(), JBossExecutors.directExecutor(), (Executor)this.handoffExecutorValue.getOptionalValue(), keepAlive);
        this.executor.setMaxThreads(this.maxThreads);
        this.executor.setBlocking(this.blocking);
        this.value = JBossExecutors.protectedExecutorService((Executor)this.executor);
    }

    public synchronized void stop(StopContext context) {
        QueuelessExecutor executor = this.executor;
        if (executor == null) {
            throw new IllegalStateException();
        }
        context.asynchronous();
        executor.shutdown();
        executor.addShutdownListener((EventListener)new EventListener<StopContext>(){

            public void handleEvent(StopContext stopContext) {
                stopContext.complete();
            }
        }, (Object)context);
        this.executor = null;
        this.value = null;
    }

    public synchronized ExecutorService getValue() throws IllegalStateException {
        ExecutorService value = this.value;
        if (value == null) {
            throw new IllegalStateException();
        }
        return value;
    }

    public Injector<ThreadFactory> getThreadFactoryInjector() {
        return this.threadFactoryValue;
    }

    public Injector<Executor> getHandoffExecutorInjector() {
        return this.handoffExecutorValue;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        QueuelessExecutor executor = this.executor;
        if (executor != null) {
            executor.setMaxThreads(maxThreads);
        }
    }

    public synchronized void setBlocking(boolean blocking) {
        this.blocking = blocking;
        QueuelessExecutor executor = this.executor;
        if (executor != null) {
            executor.setBlocking(blocking);
        }
    }

    public synchronized void setKeepAlive(TimeSpec keepAliveSpec) {
        this.keepAlive = keepAliveSpec;
        QueuelessExecutor executor = this.executor;
        if (executor != null) {
            long keepAlive = keepAliveSpec == null ? Long.MAX_VALUE : keepAliveSpec.getDuration();
            executor.setKeepAliveTime(keepAlive);
        }
    }
}

