/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.threads.BoundedQueueThreadPoolService;
import org.jboss.as.threads.ThreadPoolReadAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;

public class BoundedQueueThreadPoolReadAttributeHandler
extends ThreadPoolReadAttributeHandler {
    public static final List<String> METRICS = Arrays.asList("current-thread-count", "largest-thread-count");
    public static final BoundedQueueThreadPoolReadAttributeHandler INSTANCE = new BoundedQueueThreadPoolReadAttributeHandler();

    public BoundedQueueThreadPoolReadAttributeHandler() {
        super(METRICS);
    }

    @Override
    protected void setResult(OperationContext context, String attributeName, Service<?> service) throws OperationFailedException {
        BoundedQueueThreadPoolService bounded = (BoundedQueueThreadPoolService)service;
        if (attributeName.equals("current-thread-count")) {
            context.getResult().set(bounded.getCurrentThreadCount());
        } else if (attributeName.equals("largest-thread-count")) {
            context.getResult().set(bounded.getLargestThreadCount());
        } else if (METRICS.contains(attributeName)) {
            throw new OperationFailedException(new ModelNode().set("Unsupported attribute '" + attributeName + "'"));
        }
    }
}

