/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.threads.ScaledCount;
import org.jboss.as.threads.ThreadFactoryService;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.threads.TimeSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

class ThreadsSubsystemThreadPoolOperationUtils {
    ThreadsSubsystemThreadPoolOperationUtils() {
    }

    static <T> void addThreadFactoryDependency(String threadFactory, ServiceName serviceName, ServiceBuilder<T> serviceBuilder, Injector<ThreadFactory> injector, ServiceTarget target, String defaultThreadGroupName) {
        ServiceName threadFactoryName;
        if (threadFactory == null) {
            threadFactoryName = serviceName.append(new String[]{"thread-factory"});
            ThreadFactoryService service = new ThreadFactoryService();
            service.setThreadGroupName(defaultThreadGroupName);
            service.setNamePattern("%G - %t");
            target.addService(threadFactoryName, (Service)service).install();
        } else {
            threadFactoryName = ThreadsServices.threadFactoryName(threadFactory);
        }
        serviceBuilder.addDependency(threadFactoryName, ThreadFactory.class, injector);
    }

    static BaseOperationParameters parseUnboundedQueueThreadPoolOperationParameters(ModelNode operation) {
        OperationParametersImpl params = new OperationParametersImpl();
        return ThreadsSubsystemThreadPoolOperationUtils.parseBaseThreadPoolOperationParameters(operation, params);
    }

    static BaseOperationParameters parseScheduledThreadPoolOperationParameters(ModelNode operation) {
        OperationParametersImpl params = new OperationParametersImpl();
        return ThreadsSubsystemThreadPoolOperationUtils.parseBaseThreadPoolOperationParameters(operation, params);
    }

    static QueuelessOperationParameters parseQueuelessThreadPoolOperationParameters(ModelNode operation) {
        OperationParametersImpl params = new OperationParametersImpl();
        ThreadsSubsystemThreadPoolOperationUtils.parseBaseThreadPoolOperationParameters(operation, params);
        params.blocking = operation.hasDefined("blocking") ? operation.get("blocking").asBoolean() : false;
        params.handoffExecutor = operation.hasDefined("handoff-executor") ? operation.get("handoff-executor").asString() : null;
        return params;
    }

    static BoundedOperationParameters parseBoundedThreadPoolOperationParameters(ModelNode operation) {
        OperationParametersImpl params = new OperationParametersImpl();
        ThreadsSubsystemThreadPoolOperationUtils.parseBaseThreadPoolOperationParameters(operation, params);
        params.blocking = operation.hasDefined("blocking") ? operation.get("blocking").asBoolean() : false;
        params.allowCoreTimeout = operation.hasDefined("allow-core-timeout") ? operation.get("allow-core-timeout").asBoolean() : false;
        params.handoffExecutor = operation.hasDefined("handoff-executor") ? operation.get("handoff-executor").asString() : null;
        params.coreThreads = ThreadsSubsystemThreadPoolOperationUtils.getScaledCount(operation, "core-threads");
        params.queueLength = ThreadsSubsystemThreadPoolOperationUtils.getScaledCount(operation, "queue-length");
        return params;
    }

    private static OperationParametersImpl parseBaseThreadPoolOperationParameters(ModelNode operation, OperationParametersImpl params) {
        params.address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)params.address);
        params.name = pathAddress.getLastElement().getValue();
        params.threadFactory = operation.hasDefined("thread-factory") ? operation.get("thread-factory").asString() : null;
        ModelNode modelNode = params.properties = operation.hasDefined("properties") ? operation.get("properties") : null;
        if (params.properties != null) {
            if (params.properties.getType() != ModelType.LIST) {
                throw new IllegalArgumentException("properties must be a list of properties");
            }
            for (ModelNode property : params.properties.asList()) {
                if (property.getType() == ModelType.PROPERTY) continue;
                throw new IllegalArgumentException("properties must be a list of properties");
            }
        }
        params.maxThreads = ThreadsSubsystemThreadPoolOperationUtils.getScaledCount(operation, "max-threads");
        if (params.maxThreads == null) {
            throw new IllegalArgumentException("max-threads was not defined");
        }
        if (operation.hasDefined("keepalive-time")) {
            ModelNode keepaliveTime = operation.get("keepalive-time");
            if (!keepaliveTime.hasDefined("time")) {
                throw new IllegalArgumentException("Missing 'time' for 'keepalive-time'");
            }
            if (!keepaliveTime.hasDefined("unit")) {
                throw new IllegalArgumentException("Missing 'unit' for 'keepalive-time'");
            }
            params.keepAliveTime = new TimeSpec(Enum.valueOf(TimeUnit.class, keepaliveTime.get("unit").asString()), keepaliveTime.get("time").asLong());
        }
        return params;
    }

    private static ScaledCount getScaledCount(ModelNode operation, String paramName) {
        if (operation.hasDefined(paramName)) {
            ModelNode scaledCount = operation.get(paramName);
            if (!scaledCount.hasDefined("count")) {
                throw new IllegalArgumentException("Missing 'count' for '" + paramName + "'");
            }
            if (!scaledCount.hasDefined("per-cpu")) {
                throw new IllegalArgumentException("Missing 'per-cpu' for '" + paramName + "'");
            }
            return new ScaledCount(scaledCount.get("count").asBigDecimal(), scaledCount.get("per-cpu").asBigDecimal());
        }
        return null;
    }

    private static class OperationParametersImpl
    implements QueuelessOperationParameters,
    BoundedOperationParameters {
        ModelNode address;
        String name;
        String threadFactory;
        ModelNode properties;
        ScaledCount maxThreads;
        TimeSpec keepAliveTime;
        boolean blocking;
        String handoffExecutor;
        boolean allowCoreTimeout;
        ScaledCount coreThreads;
        ScaledCount queueLength;

        private OperationParametersImpl() {
        }

        @Override
        public ModelNode getAddress() {
            return this.address;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getThreadFactory() {
            return this.threadFactory;
        }

        @Override
        public ModelNode getProperties() {
            return this.properties;
        }

        @Override
        public ScaledCount getMaxThreads() {
            return this.maxThreads;
        }

        @Override
        public TimeSpec getKeepAliveTime() {
            return this.keepAliveTime;
        }

        @Override
        public boolean isBlocking() {
            return this.blocking;
        }

        @Override
        public String getHandoffExecutor() {
            return this.handoffExecutor;
        }

        @Override
        public boolean isAllowCoreTimeout() {
            return this.allowCoreTimeout;
        }

        @Override
        public ScaledCount getCoreThreads() {
            return this.coreThreads;
        }

        @Override
        public ScaledCount getQueueLength() {
            return this.queueLength;
        }
    }

    static interface BoundedOperationParameters
    extends QueuelessOperationParameters {
        public boolean isAllowCoreTimeout();

        public ScaledCount getCoreThreads();

        public ScaledCount getQueueLength();
    }

    static interface QueuelessOperationParameters
    extends BaseOperationParameters {
        public boolean isBlocking();

        public String getHandoffExecutor();
    }

    static interface BaseOperationParameters {
        public ModelNode getAddress();

        public String getName();

        public String getThreadFactory();

        public ModelNode getProperties();

        public ScaledCount getMaxThreads();

        public TimeSpec getKeepAliveTime();
    }
}

